<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getFolderListRequest StructType
 * @subpackage Structs
 */
class GetFolderListRequest extends AbstractStructBase
{
    /**
     * The parent
     * Meta informations extracted from the WSDL
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - minOccurs: 0
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $parent;
    /**
     * The view
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $view;
    /**
     * The recurse
     * @var bool
     */
    public $recurse;
    /**
     * The imap
     * Meta informations extracted from the WSDL
     * - default: 0
     * @var bool
     */
    public $imap;
    /**
     * The nntp
     * Meta informations extracted from the WSDL
     * - default: 0
     * @var bool
     */
    public $nntp;
    /**
     * Constructor method for getFolderListRequest
     * @uses GetFolderListRequest::setParent()
     * @uses GetFolderListRequest::setView()
     * @uses GetFolderListRequest::setRecurse()
     * @uses GetFolderListRequest::setImap()
     * @uses GetFolderListRequest::setNntp()
     * @param string $parent
     * @param string $view
     * @param bool $recurse
     * @param bool $imap
     * @param bool $nntp
     */
    public function __construct($parent = null, $view = null, $recurse = null, $imap = false, $nntp = false)
    {
        $this
            ->setParent($parent)
            ->setView($view)
            ->setRecurse($recurse)
            ->setImap($imap)
            ->setNntp($nntp);
    }
    /**
     * Get parent value
     * @return string|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param string $parent
     * @return \StructType\GetFolderListRequest
     */
    public function setParent($parent = null)
    {
        // validation for constraint: pattern
        if (is_scalar($parent) && !preg_match('/[^@]+(@*)?/', $parent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($parent, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($parent) && !is_string($parent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parent)), __LINE__);
        }
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get view value
     * @return string|null
     */
    public function getView()
    {
        return $this->view;
    }
    /**
     * Set view value
     * @param string $view
     * @return \StructType\GetFolderListRequest
     */
    public function setView($view = null)
    {
        // validation for constraint: string
        if (!is_null($view) && !is_string($view)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($view)), __LINE__);
        }
        $this->view = $view;
        return $this;
    }
    /**
     * Get recurse value
     * @return bool|null
     */
    public function getRecurse()
    {
        return $this->recurse;
    }
    /**
     * Set recurse value
     * @param bool $recurse
     * @return \StructType\GetFolderListRequest
     */
    public function setRecurse($recurse = null)
    {
        // validation for constraint: boolean
        if (!is_null($recurse) && !is_bool($recurse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($recurse)), __LINE__);
        }
        $this->recurse = $recurse;
        return $this;
    }
    /**
     * Get imap value
     * @return bool|null
     */
    public function getImap()
    {
        return $this->imap;
    }
    /**
     * Set imap value
     * @param bool $imap
     * @return \StructType\GetFolderListRequest
     */
    public function setImap($imap = false)
    {
        // validation for constraint: boolean
        if (!is_null($imap) && !is_bool($imap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($imap)), __LINE__);
        }
        $this->imap = $imap;
        return $this;
    }
    /**
     * Get nntp value
     * @return bool|null
     */
    public function getNntp()
    {
        return $this->nntp;
    }
    /**
     * Set nntp value
     * @param bool $nntp
     * @return \StructType\GetFolderListRequest
     */
    public function setNntp($nntp = false)
    {
        // validation for constraint: boolean
        if (!is_null($nntp) && !is_bool($nntp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($nntp)), __LINE__);
        }
        $this->nntp = $nntp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetFolderListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
