<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getAttachmentRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: This work only for file attachments. If you try to specify an embedded item, you will get an error. If you specify offset = 0 and length = -1, you will receive the whole attachment. You can supply other values for offset and length
 * to receive a part of the attachment.
 * @subpackage Structs
 */
class GetAttachmentRequest extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - minOccurs: 0
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $id;
    /**
     * The offset
     * @var int
     */
    public $offset;
    /**
     * The length
     * @var int
     */
    public $length;
    /**
     * The flags
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var string[]
     */
    public $flags;
    /**
     * Constructor method for getAttachmentRequest
     * @uses GetAttachmentRequest::setId()
     * @uses GetAttachmentRequest::setOffset()
     * @uses GetAttachmentRequest::setLength()
     * @uses GetAttachmentRequest::setFlags()
     * @param string $id
     * @param int $offset
     * @param int $length
     * @param string[] $flags
     */
    public function __construct($id = null, $offset = null, $length = null, array $flags = array())
    {
        $this
            ->setId($id)
            ->setOffset($offset)
            ->setLength($length)
            ->setFlags($flags);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\GetAttachmentRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[^@]+(@*)?/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\GetAttachmentRequest
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Get length value
     * @return int|null
     */
    public function getLength()
    {
        return $this->length;
    }
    /**
     * Set length value
     * @param int $length
     * @return \StructType\GetAttachmentRequest
     */
    public function setLength($length = null)
    {
        // validation for constraint: int
        if (!is_null($length) && !is_numeric($length)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($length)), __LINE__);
        }
        $this->length = $length;
        return $this;
    }
    /**
     * Get flags value
     * @return string[]|null
     */
    public function getFlags()
    {
        return $this->flags;
    }
    /**
     * Set flags value
     * @uses \EnumType\AttachmentFlags::valueIsValid()
     * @uses \EnumType\AttachmentFlags::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $flags
     * @return \StructType\GetAttachmentRequest
     */
    public function setFlags(array $flags = array())
    {
        $invalidValues = array();
        foreach ($flags as $getAttachmentRequestFlagsItem) {
            if (!\EnumType\AttachmentFlags::valueIsValid($getAttachmentRequestFlagsItem)) {
                $invalidValues[] = var_export($getAttachmentRequestFlagsItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\AttachmentFlags::getValidValues())), __LINE__);
        }
        $this->flags = $flags;
        return $this;
    }
    /**
     * Add item to flags value
     * @uses \EnumType\AttachmentFlags::valueIsValid()
     * @uses \EnumType\AttachmentFlags::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GetAttachmentRequest
     */
    public function addToFlags($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AttachmentFlags::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\AttachmentFlags::getValidValues())), __LINE__);
        }
        $this->flags[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAttachmentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
