<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeneralAccount StructType
 * @subpackage Structs
 */
class GeneralAccount extends Item
{
    /**
     * The displayName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:displayName
     * @var string
     */
    public $displayName;
    /**
     * The warnAttachmentLimit_KB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $warnAttachmentLimit_KB;
    /**
     * The warnExternalHTMLImages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $warnExternalHTMLImages;
    /**
     * The online
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PollSettings
     */
    public $online;
    /**
     * The remote
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PollSettings
     */
    public $remote;
    /**
     * The cache
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PollSettings
     */
    public $cache;
    /**
     * The NNTP
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NNTPSettings
     */
    public $NNTP;
    /**
     * Constructor method for GeneralAccount
     * @uses GeneralAccount::setDisplayName()
     * @uses GeneralAccount::setWarnAttachmentLimit_KB()
     * @uses GeneralAccount::setWarnExternalHTMLImages()
     * @uses GeneralAccount::setOnline()
     * @uses GeneralAccount::setRemote()
     * @uses GeneralAccount::setCache()
     * @uses GeneralAccount::setNNTP()
     * @param string $displayName
     * @param int $warnAttachmentLimit_KB
     * @param string $warnExternalHTMLImages
     * @param \StructType\PollSettings $online
     * @param \StructType\PollSettings $remote
     * @param \StructType\PollSettings $cache
     * @param \StructType\NNTPSettings $nNTP
     */
    public function __construct($displayName = null, $warnAttachmentLimit_KB = null, $warnExternalHTMLImages = null, \StructType\PollSettings $online = null, \StructType\PollSettings $remote = null, \StructType\PollSettings $cache = null, \StructType\NNTPSettings $nNTP = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setWarnAttachmentLimit_KB($warnAttachmentLimit_KB)
            ->setWarnExternalHTMLImages($warnExternalHTMLImages)
            ->setOnline($online)
            ->setRemote($remote)
            ->setCache($cache)
            ->setNNTP($nNTP);
    }
    /**
     * Get displayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * Set displayName value
     * @param string $displayName
     * @return \StructType\GeneralAccount
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->displayName = $displayName;
        return $this;
    }
    /**
     * Get warnAttachmentLimit_KB value
     * @return int|null
     */
    public function getWarnAttachmentLimit_KB()
    {
        return $this->warnAttachmentLimit_KB;
    }
    /**
     * Set warnAttachmentLimit_KB value
     * @param int $warnAttachmentLimit_KB
     * @return \StructType\GeneralAccount
     */
    public function setWarnAttachmentLimit_KB($warnAttachmentLimit_KB = null)
    {
        // validation for constraint: int
        if (!is_null($warnAttachmentLimit_KB) && !is_numeric($warnAttachmentLimit_KB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($warnAttachmentLimit_KB)), __LINE__);
        }
        $this->warnAttachmentLimit_KB = $warnAttachmentLimit_KB;
        return $this;
    }
    /**
     * Get warnExternalHTMLImages value
     * @return string|null
     */
    public function getWarnExternalHTMLImages()
    {
        return $this->warnExternalHTMLImages;
    }
    /**
     * Set warnExternalHTMLImages value
     * @uses \EnumType\HTMLImages::valueIsValid()
     * @uses \EnumType\HTMLImages::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $warnExternalHTMLImages
     * @return \StructType\GeneralAccount
     */
    public function setWarnExternalHTMLImages($warnExternalHTMLImages = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HTMLImages::valueIsValid($warnExternalHTMLImages)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $warnExternalHTMLImages, implode(', ', \EnumType\HTMLImages::getValidValues())), __LINE__);
        }
        $this->warnExternalHTMLImages = $warnExternalHTMLImages;
        return $this;
    }
    /**
     * Get online value
     * @return \StructType\PollSettings|null
     */
    public function getOnline()
    {
        return $this->online;
    }
    /**
     * Set online value
     * @param \StructType\PollSettings $online
     * @return \StructType\GeneralAccount
     */
    public function setOnline(\StructType\PollSettings $online = null)
    {
        $this->online = $online;
        return $this;
    }
    /**
     * Get remote value
     * @return \StructType\PollSettings|null
     */
    public function getRemote()
    {
        return $this->remote;
    }
    /**
     * Set remote value
     * @param \StructType\PollSettings $remote
     * @return \StructType\GeneralAccount
     */
    public function setRemote(\StructType\PollSettings $remote = null)
    {
        $this->remote = $remote;
        return $this;
    }
    /**
     * Get cache value
     * @return \StructType\PollSettings|null
     */
    public function getCache()
    {
        return $this->cache;
    }
    /**
     * Set cache value
     * @param \StructType\PollSettings $cache
     * @return \StructType\GeneralAccount
     */
    public function setCache(\StructType\PollSettings $cache = null)
    {
        $this->cache = $cache;
        return $this;
    }
    /**
     * Get NNTP value
     * @return \StructType\NNTPSettings|null
     */
    public function getNNTP()
    {
        return $this->NNTP;
    }
    /**
     * Set NNTP value
     * @param \StructType\NNTPSettings $nNTP
     * @return \StructType\GeneralAccount
     */
    public function setNNTP(\StructType\NNTPSettings $nNTP = null)
    {
        $this->NNTP = $nNTP;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GeneralAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
