<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FullName StructType
 * @subpackage Structs
 */
class FullName extends AbstractStructBase
{
    /**
     * The displayName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:displayName
     * @var string
     */
    public $displayName;
    /**
     * The namePrefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $namePrefix;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The middleName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $middleName;
    /**
     * The lastName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The nameSuffix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nameSuffix;
    /**
     * Constructor method for FullName
     * @uses FullName::setDisplayName()
     * @uses FullName::setNamePrefix()
     * @uses FullName::setFirstName()
     * @uses FullName::setMiddleName()
     * @uses FullName::setLastName()
     * @uses FullName::setNameSuffix()
     * @param string $displayName
     * @param string $namePrefix
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     * @param string $nameSuffix
     */
    public function __construct($displayName = null, $namePrefix = null, $firstName = null, $middleName = null, $lastName = null, $nameSuffix = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setNamePrefix($namePrefix)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setLastName($lastName)
            ->setNameSuffix($nameSuffix);
    }
    /**
     * Get displayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * Set displayName value
     * @param string $displayName
     * @return \StructType\FullName
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->displayName = $displayName;
        return $this;
    }
    /**
     * Get namePrefix value
     * @return string|null
     */
    public function getNamePrefix()
    {
        return $this->namePrefix;
    }
    /**
     * Set namePrefix value
     * @param string $namePrefix
     * @return \StructType\FullName
     */
    public function setNamePrefix($namePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($namePrefix) && !is_string($namePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($namePrefix)), __LINE__);
        }
        $this->namePrefix = $namePrefix;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\FullName
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return \StructType\FullName
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\FullName
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get nameSuffix value
     * @return string|null
     */
    public function getNameSuffix()
    {
        return $this->nameSuffix;
    }
    /**
     * Set nameSuffix value
     * @param string $nameSuffix
     * @return \StructType\FullName
     */
    public function setNameSuffix($nameSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($nameSuffix) && !is_string($nameSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameSuffix)), __LINE__);
        }
        $this->nameSuffix = $nameSuffix;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FullName
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
