<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FreeBusyStats StructType
 * @subpackage Structs
 */
class FreeBusyStats extends AbstractStructBase
{
    /**
     * The responded
     * @var int
     */
    public $responded;
    /**
     * The outstanding
     * @var int
     */
    public $outstanding;
    /**
     * The total
     * @var int
     */
    public $total;
    /**
     * Constructor method for FreeBusyStats
     * @uses FreeBusyStats::setResponded()
     * @uses FreeBusyStats::setOutstanding()
     * @uses FreeBusyStats::setTotal()
     * @param int $responded
     * @param int $outstanding
     * @param int $total
     */
    public function __construct($responded = null, $outstanding = null, $total = null)
    {
        $this
            ->setResponded($responded)
            ->setOutstanding($outstanding)
            ->setTotal($total);
    }
    /**
     * Get responded value
     * @return int|null
     */
    public function getResponded()
    {
        return $this->responded;
    }
    /**
     * Set responded value
     * @param int $responded
     * @return \StructType\FreeBusyStats
     */
    public function setResponded($responded = null)
    {
        // validation for constraint: int
        if (!is_null($responded) && !is_numeric($responded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($responded)), __LINE__);
        }
        $this->responded = $responded;
        return $this;
    }
    /**
     * Get outstanding value
     * @return int|null
     */
    public function getOutstanding()
    {
        return $this->outstanding;
    }
    /**
     * Set outstanding value
     * @param int $outstanding
     * @return \StructType\FreeBusyStats
     */
    public function setOutstanding($outstanding = null)
    {
        // validation for constraint: int
        if (!is_null($outstanding) && !is_numeric($outstanding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($outstanding)), __LINE__);
        }
        $this->outstanding = $outstanding;
        return $this;
    }
    /**
     * Get total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\FreeBusyStats
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FreeBusyStats
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
