<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FreeBusyBlock StructType
 * @subpackage Structs
 */
class FreeBusyBlock extends AbstractStructBase
{
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - ref: tns:startDate
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - ref: tns:endDate
     * @var string
     */
    public $endDate;
    /**
     * The acceptLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:acceptLevel
     * @var string
     */
    public $acceptLevel;
    /**
     * The subject
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:subject
     * @var string
     */
    public $subject;
    /**
     * The place
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:place
     * @var string
     */
    public $place;
    /**
     * The from
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\From
     */
    public $from;
    /**
     * Constructor method for FreeBusyBlock
     * @uses FreeBusyBlock::setStartDate()
     * @uses FreeBusyBlock::setEndDate()
     * @uses FreeBusyBlock::setAcceptLevel()
     * @uses FreeBusyBlock::setSubject()
     * @uses FreeBusyBlock::setPlace()
     * @uses FreeBusyBlock::setFrom()
     * @param string $startDate
     * @param string $endDate
     * @param string $acceptLevel
     * @param string $subject
     * @param string $place
     * @param \StructType\From $from
     */
    public function __construct($startDate = null, $endDate = null, $acceptLevel = null, $subject = null, $place = null, \StructType\From $from = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setAcceptLevel($acceptLevel)
            ->setSubject($subject)
            ->setPlace($place)
            ->setFrom($from);
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\FreeBusyBlock
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\FreeBusyBlock
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get acceptLevel value
     * @return string|null
     */
    public function getAcceptLevel()
    {
        return $this->acceptLevel;
    }
    /**
     * Set acceptLevel value
     * @uses \EnumType\AcceptLevel::valueIsValid()
     * @uses \EnumType\AcceptLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $acceptLevel
     * @return \StructType\FreeBusyBlock
     */
    public function setAcceptLevel($acceptLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AcceptLevel::valueIsValid($acceptLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $acceptLevel, implode(', ', \EnumType\AcceptLevel::getValidValues())), __LINE__);
        }
        $this->acceptLevel = $acceptLevel;
        return $this;
    }
    /**
     * Get subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->subject;
    }
    /**
     * Set subject value
     * @param string $subject
     * @return \StructType\FreeBusyBlock
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subject)), __LINE__);
        }
        $this->subject = $subject;
        return $this;
    }
    /**
     * Get place value
     * @return string|null
     */
    public function getPlace()
    {
        return $this->place;
    }
    /**
     * Set place value
     * @param string $place
     * @return \StructType\FreeBusyBlock
     */
    public function setPlace($place = null)
    {
        // validation for constraint: string
        if (!is_null($place) && !is_string($place)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($place)), __LINE__);
        }
        $this->place = $place;
        return $this;
    }
    /**
     * Get from value
     * @return \StructType\From|null
     */
    public function getFrom()
    {
        return $this->from;
    }
    /**
     * Set from value
     * @param \StructType\From $from
     * @return \StructType\FreeBusyBlock
     */
    public function setFrom(\StructType\From $from = null)
    {
        $this->from = $from;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FreeBusyBlock
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
