<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for forwardRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Forwarding a message is a two step process. First you call the method with the id of the original item. A new mail item is returned. It has the original subject. The caller is responsible to prepend "Fwd:" or what ever they want to
 * modify the original subject. If the caller wants the original message body returned, they need to supply message or message/RTF in the view. It is up to the caller to modify the message body in any way. When all of the changes to the returned mail
 * item are complete, the caller would then call sendRequest with the new mail item. A linkInfo element is return in the mail item. That element needs to be passed unchanged in the sendRequest. If the caller wants to send the original item as an
 * attachment to the new mail item, the caller would pass the 'embed' element in the forwardRequest.
 * @subpackage Structs
 */
class ForwardRequest extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - minOccurs: 0
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $id;
    /**
     * The view
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $view;
    /**
     * The embed
     * Meta informations extracted from the WSDL
     * - default: 0
     * @var bool
     */
    public $embed;
    /**
     * Constructor method for forwardRequest
     * @uses ForwardRequest::setId()
     * @uses ForwardRequest::setView()
     * @uses ForwardRequest::setEmbed()
     * @param string $id
     * @param string $view
     * @param bool $embed
     */
    public function __construct($id = null, $view = null, $embed = false)
    {
        $this
            ->setId($id)
            ->setView($view)
            ->setEmbed($embed);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ForwardRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[^@]+(@*)?/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get view value
     * @return string|null
     */
    public function getView()
    {
        return $this->view;
    }
    /**
     * Set view value
     * @param string $view
     * @return \StructType\ForwardRequest
     */
    public function setView($view = null)
    {
        // validation for constraint: string
        if (!is_null($view) && !is_string($view)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($view)), __LINE__);
        }
        $this->view = $view;
        return $this;
    }
    /**
     * Get embed value
     * @return bool|null
     */
    public function getEmbed()
    {
        return $this->embed;
    }
    /**
     * Set embed value
     * @param bool $embed
     * @return \StructType\ForwardRequest
     */
    public function setEmbed($embed = false)
    {
        // validation for constraint: boolean
        if (!is_null($embed) && !is_bool($embed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($embed)), __LINE__);
        }
        $this->embed = $embed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ForwardRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
