<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FolderACL StructType
 * @subpackage Structs
 */
class FolderACL extends AbstractStructBase
{
    /**
     * The entry
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FolderACLEntry[]
     */
    public $entry;
    /**
     * Constructor method for FolderACL
     * @uses FolderACL::setEntry()
     * @param \StructType\FolderACLEntry[] $entry
     */
    public function __construct(array $entry = array())
    {
        $this
            ->setEntry($entry);
    }
    /**
     * Get entry value
     * @return \StructType\FolderACLEntry[]|null
     */
    public function getEntry()
    {
        return $this->entry;
    }
    /**
     * Set entry value
     * @throws \InvalidArgumentException
     * @param \StructType\FolderACLEntry[] $entry
     * @return \StructType\FolderACL
     */
    public function setEntry(array $entry = array())
    {
        foreach ($entry as $folderACLEntryItem) {
            // validation for constraint: itemType
            if (!$folderACLEntryItem instanceof \StructType\FolderACLEntry) {
                throw new \InvalidArgumentException(sprintf('The entry property can only contain items of \StructType\FolderACLEntry, "%s" given', is_object($folderACLEntryItem) ? get_class($folderACLEntryItem) : gettype($folderACLEntryItem)), __LINE__);
            }
        }
        $this->entry = $entry;
        return $this;
    }
    /**
     * Add item to entry value
     * @throws \InvalidArgumentException
     * @param \StructType\FolderACLEntry $item
     * @return \StructType\FolderACL
     */
    public function addToEntry(\StructType\FolderACLEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FolderACLEntry) {
            throw new \InvalidArgumentException(sprintf('The entry property can only contain items of \StructType\FolderACLEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->entry[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FolderACL
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
