<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Folder StructType
 * Meta informations extracted from the WSDL
 * - maxOccurs: unbounded
 * - minOccurs: 0
 * - type: xs:string
 * @subpackage Structs
 */
class Folder extends Item
{
    /**
     * The parent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $parent;
    /**
     * The displayReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $displayReference;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:description
     * @var string
     */
    public $description;
    /**
     * The count
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $count;
    /**
     * The hasUnread
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $hasUnread;
    /**
     * The unreadCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $unreadCount;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:sequence
     * @var int
     */
    public $sequence;
    /**
     * The calendarAttribute
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CalendarFolderAttribute
     */
    public $calendarAttribute;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * The frequency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $frequency;
    /**
     * The displaySettings
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FolderDisplaySettings
     */
    public $displaySettings;
    /**
     * The flags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FolderFlags
     */
    public $flags;
    /**
     * Constructor method for Folder
     * @uses Folder::setParent()
     * @uses Folder::setDisplayReference()
     * @uses Folder::setDescription()
     * @uses Folder::setCount()
     * @uses Folder::setHasUnread()
     * @uses Folder::setUnreadCount()
     * @uses Folder::setSequence()
     * @uses Folder::setCalendarAttribute()
     * @uses Folder::setURL()
     * @uses Folder::setFrequency()
     * @uses Folder::setDisplaySettings()
     * @uses Folder::setFlags()
     * @param string $parent
     * @param string $displayReference
     * @param string $description
     * @param int $count
     * @param bool $hasUnread
     * @param int $unreadCount
     * @param int $sequence
     * @param \StructType\CalendarFolderAttribute $calendarAttribute
     * @param string $uRL
     * @param int $frequency
     * @param \StructType\FolderDisplaySettings $displaySettings
     * @param \StructType\FolderFlags $flags
     */
    public function __construct($parent = null, $displayReference = null, $description = null, $count = null, $hasUnread = null, $unreadCount = null, $sequence = null, \StructType\CalendarFolderAttribute $calendarAttribute = null, $uRL = null, $frequency = null, \StructType\FolderDisplaySettings $displaySettings = null, \StructType\FolderFlags $flags = null)
    {
        $this
            ->setParent($parent)
            ->setDisplayReference($displayReference)
            ->setDescription($description)
            ->setCount($count)
            ->setHasUnread($hasUnread)
            ->setUnreadCount($unreadCount)
            ->setSequence($sequence)
            ->setCalendarAttribute($calendarAttribute)
            ->setURL($uRL)
            ->setFrequency($frequency)
            ->setDisplaySettings($displaySettings)
            ->setFlags($flags);
    }
    /**
     * Get parent value
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param string $parent
     * @return \StructType\Folder
     */
    public function setParent($parent = null)
    {
        // validation for constraint: pattern
        if (is_scalar($parent) && !preg_match('/[^@]+(@*)?/', $parent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($parent, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($parent) && !is_string($parent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parent)), __LINE__);
        }
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get displayReference value
     * @return string
     */
    public function getDisplayReference()
    {
        return $this->displayReference;
    }
    /**
     * Set displayReference value
     * @param string $displayReference
     * @return \StructType\Folder
     */
    public function setDisplayReference($displayReference = null)
    {
        // validation for constraint: pattern
        if (is_scalar($displayReference) && !preg_match('/[^@]+(@*)?/', $displayReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($displayReference, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($displayReference) && !is_string($displayReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayReference)), __LINE__);
        }
        $this->displayReference = $displayReference;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Folder
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\Folder
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !is_numeric($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get hasUnread value
     * @return bool|null
     */
    public function getHasUnread()
    {
        return $this->hasUnread;
    }
    /**
     * Set hasUnread value
     * @param bool $hasUnread
     * @return \StructType\Folder
     */
    public function setHasUnread($hasUnread = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasUnread) && !is_bool($hasUnread)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasUnread)), __LINE__);
        }
        $this->hasUnread = $hasUnread;
        return $this;
    }
    /**
     * Get unreadCount value
     * @return int|null
     */
    public function getUnreadCount()
    {
        return $this->unreadCount;
    }
    /**
     * Set unreadCount value
     * @param int $unreadCount
     * @return \StructType\Folder
     */
    public function setUnreadCount($unreadCount = null)
    {
        // validation for constraint: int
        if (!is_null($unreadCount) && !is_numeric($unreadCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unreadCount)), __LINE__);
        }
        $this->unreadCount = $unreadCount;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \StructType\Folder
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Get calendarAttribute value
     * @return \StructType\CalendarFolderAttribute|null
     */
    public function getCalendarAttribute()
    {
        return $this->calendarAttribute;
    }
    /**
     * Set calendarAttribute value
     * @param \StructType\CalendarFolderAttribute $calendarAttribute
     * @return \StructType\Folder
     */
    public function setCalendarAttribute(\StructType\CalendarFolderAttribute $calendarAttribute = null)
    {
        $this->calendarAttribute = $calendarAttribute;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\Folder
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get frequency value
     * @return int|null
     */
    public function getFrequency()
    {
        return $this->frequency;
    }
    /**
     * Set frequency value
     * @param int $frequency
     * @return \StructType\Folder
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: int
        if (!is_null($frequency) && !is_numeric($frequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($frequency)), __LINE__);
        }
        $this->frequency = $frequency;
        return $this;
    }
    /**
     * Get displaySettings value
     * @return \StructType\FolderDisplaySettings|null
     */
    public function getDisplaySettings()
    {
        return $this->displaySettings;
    }
    /**
     * Set displaySettings value
     * @param \StructType\FolderDisplaySettings $displaySettings
     * @return \StructType\Folder
     */
    public function setDisplaySettings(\StructType\FolderDisplaySettings $displaySettings = null)
    {
        $this->displaySettings = $displaySettings;
        return $this;
    }
    /**
     * Get flags value
     * @return \StructType\FolderFlags|null
     */
    public function getFlags()
    {
        return $this->flags;
    }
    /**
     * Set flags value
     * @param \StructType\FolderFlags $flags
     * @return \StructType\Folder
     */
    public function setFlags(\StructType\FolderFlags $flags = null)
    {
        $this->flags = $flags;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Folder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
