<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FilterGroup StructType
 * Meta informations extracted from the WSDL
 * - documentation: FilterGroup comprises FilterOp "and", "or" or "not"
 * @subpackage Structs
 */
class FilterGroup extends FilterElement
{
    /**
     * The element
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\FilterElement[]
     */
    public $element;
    /**
     * Constructor method for FilterGroup
     * @uses FilterGroup::setElement()
     * @param \StructType\FilterElement[] $element
     */
    public function __construct(array $element = array())
    {
        $this
            ->setElement($element);
    }
    /**
     * Get element value
     * @return \StructType\FilterElement[]
     */
    public function getElement()
    {
        return $this->element;
    }
    /**
     * Set element value
     * @throws \InvalidArgumentException
     * @param \StructType\FilterElement[] $element
     * @return \StructType\FilterGroup
     */
    public function setElement(array $element = array())
    {
        foreach ($element as $filterGroupElementItem) {
            // validation for constraint: itemType
            if (!$filterGroupElementItem instanceof \StructType\FilterElement) {
                throw new \InvalidArgumentException(sprintf('The element property can only contain items of \StructType\FilterElement, "%s" given', is_object($filterGroupElementItem) ? get_class($filterGroupElementItem) : gettype($filterGroupElementItem)), __LINE__);
            }
        }
        $this->element = $element;
        return $this;
    }
    /**
     * Add item to element value
     * @throws \InvalidArgumentException
     * @param \StructType\FilterElement $item
     * @return \StructType\FilterGroup
     */
    public function addToElement(\StructType\FilterElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FilterElement) {
            throw new \InvalidArgumentException(sprintf('The element property can only contain items of \StructType\FilterElement, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->element[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FilterGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
