<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FilterElement StructType
 * @subpackage Structs
 */
class FilterElement extends AbstractStructBase
{
    /**
     * The op
     * @var string
     */
    public $op;
    /**
     * Constructor method for FilterElement
     * @uses FilterElement::setOp()
     * @param string $op
     */
    public function __construct($op = null)
    {
        $this
            ->setOp($op);
    }
    /**
     * Get op value
     * @return string|null
     */
    public function getOp()
    {
        return $this->op;
    }
    /**
     * Set op value
     * @uses \EnumType\FilterOp::valueIsValid()
     * @uses \EnumType\FilterOp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $op
     * @return \StructType\FilterElement
     */
    public function setOp($op = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FilterOp::valueIsValid($op)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $op, implode(', ', \EnumType\FilterOp::getValidValues())), __LINE__);
        }
        $this->op = $op;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FilterElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
