<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventsList StructType
 * @subpackage Structs
 */
class EventsList extends AbstractStructBase
{
    /**
     * The event
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Events[]
     */
    public $event;
    /**
     * Constructor method for EventsList
     * @uses EventsList::setEvent()
     * @param \StructType\Events[] $event
     */
    public function __construct(array $event = array())
    {
        $this
            ->setEvent($event);
    }
    /**
     * Get event value
     * @return \StructType\Events[]|null
     */
    public function getEvent()
    {
        return $this->event;
    }
    /**
     * Set event value
     * @throws \InvalidArgumentException
     * @param \StructType\Events[] $event
     * @return \StructType\EventsList
     */
    public function setEvent(array $event = array())
    {
        foreach ($event as $eventsListEventItem) {
            // validation for constraint: itemType
            if (!$eventsListEventItem instanceof \StructType\Events) {
                throw new \InvalidArgumentException(sprintf('The event property can only contain items of \StructType\Events, "%s" given', is_object($eventsListEventItem) ? get_class($eventsListEventItem) : gettype($eventsListEventItem)), __LINE__);
            }
        }
        $this->event = $event;
        return $this;
    }
    /**
     * Add item to event value
     * @throws \InvalidArgumentException
     * @param \StructType\Events $item
     * @return \StructType\EventsList
     */
    public function addToEvent(\StructType\Events $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Events) {
            throw new \InvalidArgumentException(sprintf('The event property can only contain items of \StructType\Events, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->event[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EventsList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
