<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventTypeList StructType
 * @subpackage Structs
 */
class EventTypeList extends AbstractStructBase
{
    /**
     * The event
     * Meta informations extracted from the WSDL
     * - maxOccurs: 36
     * - minOccurs: 1
     * @var string[]
     */
    public $event;
    /**
     * Constructor method for EventTypeList
     * @uses EventTypeList::setEvent()
     * @param string[] $event
     */
    public function __construct(array $event = array())
    {
        $this
            ->setEvent($event);
    }
    /**
     * Get event value
     * @return string[]
     */
    public function getEvent()
    {
        return $this->event;
    }
    /**
     * Set event value
     * @uses \EnumType\EventType::valueIsValid()
     * @uses \EnumType\EventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $event
     * @return \StructType\EventTypeList
     */
    public function setEvent(array $event = array())
    {
        $invalidValues = array();
        foreach ($event as $eventTypeListEventItem) {
            if (!\EnumType\EventType::valueIsValid($eventTypeListEventItem)) {
                $invalidValues[] = var_export($eventTypeListEventItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\EventType::getValidValues())), __LINE__);
        }
        $this->event = $event;
        return $this;
    }
    /**
     * Add item to event value
     * @uses \EnumType\EventType::valueIsValid()
     * @uses \EnumType\EventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\EventTypeList
     */
    public function addToEvent($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EventType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\EventType::getValidValues())), __LINE__);
        }
        $this->event[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EventTypeList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
