<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentTypeList StructType
 * @subpackage Structs
 */
class DocumentTypeList extends AbstractStructBase
{
    /**
     * The item
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DocumentType[]
     */
    public $item;
    /**
     * Constructor method for DocumentTypeList
     * @uses DocumentTypeList::setItem()
     * @param \StructType\DocumentType[] $item
     */
    public function __construct(array $item = array())
    {
        $this
            ->setItem($item);
    }
    /**
     * Get item value
     * @return \StructType\DocumentType[]|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentType[] $item
     * @return \StructType\DocumentTypeList
     */
    public function setItem(array $item = array())
    {
        foreach ($item as $documentTypeListItemItem) {
            // validation for constraint: itemType
            if (!$documentTypeListItemItem instanceof \StructType\DocumentType) {
                throw new \InvalidArgumentException(sprintf('The item property can only contain items of \StructType\DocumentType, "%s" given', is_object($documentTypeListItemItem) ? get_class($documentTypeListItemItem) : gettype($documentTypeListItemItem)), __LINE__);
            }
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Add item to item value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentType $item
     * @return \StructType\DocumentTypeList
     */
    public function addToItem(\StructType\DocumentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentType) {
            throw new \InvalidArgumentException(sprintf('The item property can only contain items of \StructType\DocumentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->item[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentTypeList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
