<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Document StructType
 * @subpackage Structs
 */
class Document extends ContainerItem
{
    /**
     * The subject
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:subject
     * @var string
     */
    public $subject;
    /**
     * The library
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NameAndEmail
     */
    public $library;
    /**
     * The documentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $documentNumber;
    /**
     * The documentTypeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $documentTypeName;
    /**
     * The author
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NameAndEmail
     */
    public $author;
    /**
     * The creator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NameAndEmail
     */
    public $creator;
    /**
     * The officialVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $officialVersion;
    /**
     * The currentVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $currentVersion;
    /**
     * The current
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccessControlList
     */
    public $current;
    /**
     * The official
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccessControlList
     */
    public $official;
    /**
     * The other
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccessControlList
     */
    public $other;
    /**
     * The size
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * @var int
     */
    public $size;
    /**
     * The filename
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $filename;
    /**
     * Constructor method for Document
     * @uses Document::setSubject()
     * @uses Document::setLibrary()
     * @uses Document::setDocumentNumber()
     * @uses Document::setDocumentTypeName()
     * @uses Document::setAuthor()
     * @uses Document::setCreator()
     * @uses Document::setOfficialVersion()
     * @uses Document::setCurrentVersion()
     * @uses Document::setCurrent()
     * @uses Document::setOfficial()
     * @uses Document::setOther()
     * @uses Document::setSize()
     * @uses Document::setFilename()
     * @param string $subject
     * @param \StructType\NameAndEmail $library
     * @param int $documentNumber
     * @param string $documentTypeName
     * @param \StructType\NameAndEmail $author
     * @param \StructType\NameAndEmail $creator
     * @param int $officialVersion
     * @param int $currentVersion
     * @param \StructType\AccessControlList $current
     * @param \StructType\AccessControlList $official
     * @param \StructType\AccessControlList $other
     * @param int $size
     * @param string $filename
     */
    public function __construct($subject = null, \StructType\NameAndEmail $library = null, $documentNumber = null, $documentTypeName = null, \StructType\NameAndEmail $author = null, \StructType\NameAndEmail $creator = null, $officialVersion = null, $currentVersion = null, \StructType\AccessControlList $current = null, \StructType\AccessControlList $official = null, \StructType\AccessControlList $other = null, $size = 0, $filename = null)
    {
        $this
            ->setSubject($subject)
            ->setLibrary($library)
            ->setDocumentNumber($documentNumber)
            ->setDocumentTypeName($documentTypeName)
            ->setAuthor($author)
            ->setCreator($creator)
            ->setOfficialVersion($officialVersion)
            ->setCurrentVersion($currentVersion)
            ->setCurrent($current)
            ->setOfficial($official)
            ->setOther($other)
            ->setSize($size)
            ->setFilename($filename);
    }
    /**
     * Get subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->subject;
    }
    /**
     * Set subject value
     * @param string $subject
     * @return \StructType\Document
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subject)), __LINE__);
        }
        $this->subject = $subject;
        return $this;
    }
    /**
     * Get library value
     * @return \StructType\NameAndEmail|null
     */
    public function getLibrary()
    {
        return $this->library;
    }
    /**
     * Set library value
     * @param \StructType\NameAndEmail $library
     * @return \StructType\Document
     */
    public function setLibrary(\StructType\NameAndEmail $library = null)
    {
        $this->library = $library;
        return $this;
    }
    /**
     * Get documentNumber value
     * @return int|null
     */
    public function getDocumentNumber()
    {
        return $this->documentNumber;
    }
    /**
     * Set documentNumber value
     * @param int $documentNumber
     * @return \StructType\Document
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($documentNumber) && !is_numeric($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($documentNumber)), __LINE__);
        }
        $this->documentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get documentTypeName value
     * @return string|null
     */
    public function getDocumentTypeName()
    {
        return $this->documentTypeName;
    }
    /**
     * Set documentTypeName value
     * @param string $documentTypeName
     * @return \StructType\Document
     */
    public function setDocumentTypeName($documentTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($documentTypeName) && !is_string($documentTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentTypeName)), __LINE__);
        }
        $this->documentTypeName = $documentTypeName;
        return $this;
    }
    /**
     * Get author value
     * @return \StructType\NameAndEmail|null
     */
    public function getAuthor()
    {
        return $this->author;
    }
    /**
     * Set author value
     * @param \StructType\NameAndEmail $author
     * @return \StructType\Document
     */
    public function setAuthor(\StructType\NameAndEmail $author = null)
    {
        $this->author = $author;
        return $this;
    }
    /**
     * Get creator value
     * @return \StructType\NameAndEmail|null
     */
    public function getCreator()
    {
        return $this->creator;
    }
    /**
     * Set creator value
     * @param \StructType\NameAndEmail $creator
     * @return \StructType\Document
     */
    public function setCreator(\StructType\NameAndEmail $creator = null)
    {
        $this->creator = $creator;
        return $this;
    }
    /**
     * Get officialVersion value
     * @return int|null
     */
    public function getOfficialVersion()
    {
        return $this->officialVersion;
    }
    /**
     * Set officialVersion value
     * @param int $officialVersion
     * @return \StructType\Document
     */
    public function setOfficialVersion($officialVersion = null)
    {
        // validation for constraint: int
        if (!is_null($officialVersion) && !is_numeric($officialVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($officialVersion)), __LINE__);
        }
        $this->officialVersion = $officialVersion;
        return $this;
    }
    /**
     * Get currentVersion value
     * @return int|null
     */
    public function getCurrentVersion()
    {
        return $this->currentVersion;
    }
    /**
     * Set currentVersion value
     * @param int $currentVersion
     * @return \StructType\Document
     */
    public function setCurrentVersion($currentVersion = null)
    {
        // validation for constraint: int
        if (!is_null($currentVersion) && !is_numeric($currentVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currentVersion)), __LINE__);
        }
        $this->currentVersion = $currentVersion;
        return $this;
    }
    /**
     * Get current value
     * @return \StructType\AccessControlList|null
     */
    public function getCurrent()
    {
        return $this->current;
    }
    /**
     * Set current value
     * @param \StructType\AccessControlList $current
     * @return \StructType\Document
     */
    public function setCurrent(\StructType\AccessControlList $current = null)
    {
        $this->current = $current;
        return $this;
    }
    /**
     * Get official value
     * @return \StructType\AccessControlList|null
     */
    public function getOfficial()
    {
        return $this->official;
    }
    /**
     * Set official value
     * @param \StructType\AccessControlList $official
     * @return \StructType\Document
     */
    public function setOfficial(\StructType\AccessControlList $official = null)
    {
        $this->official = $official;
        return $this;
    }
    /**
     * Get other value
     * @return \StructType\AccessControlList|null
     */
    public function getOther()
    {
        return $this->other;
    }
    /**
     * Set other value
     * @param \StructType\AccessControlList $other
     * @return \StructType\Document
     */
    public function setOther(\StructType\AccessControlList $other = null)
    {
        $this->other = $other;
        return $this;
    }
    /**
     * Get size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param int $size
     * @return \StructType\Document
     */
    public function setSize($size = 0)
    {
        // validation for constraint: int
        if (!is_null($size) && !is_numeric($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($size)), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
    /**
     * Get filename value
     * @return string|null
     */
    public function getFilename()
    {
        return $this->filename;
    }
    /**
     * Set filename value
     * @param string $filename
     * @return \StructType\Document
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filename)), __LINE__);
        }
        $this->filename = $filename;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Document
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
