<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Distribution StructType
 * Meta informations extracted from the WSDL
 * - minOccurs: 0
 * - type: tns:ReplyOptions
 * @subpackage Structs
 */
class Distribution extends AbstractStructBase
{
    /**
     * The from
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\From
     */
    public $from;
    /**
     * The to
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $to;
    /**
     * The cc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cc;
    /**
     * The bc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bc;
    /**
     * The recipients
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecipientList
     */
    public $recipients;
    /**
     * The sendoptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SendOptions
     */
    public $sendoptions;
    /**
     * Constructor method for Distribution
     * @uses Distribution::setFrom()
     * @uses Distribution::setTo()
     * @uses Distribution::setCc()
     * @uses Distribution::setBc()
     * @uses Distribution::setRecipients()
     * @uses Distribution::setSendoptions()
     * @param \StructType\From $from
     * @param string $to
     * @param string $cc
     * @param string $bc
     * @param \StructType\RecipientList $recipients
     * @param \StructType\SendOptions $sendoptions
     */
    public function __construct(\StructType\From $from = null, $to = null, $cc = null, $bc = null, \StructType\RecipientList $recipients = null, \StructType\SendOptions $sendoptions = null)
    {
        $this
            ->setFrom($from)
            ->setTo($to)
            ->setCc($cc)
            ->setBc($bc)
            ->setRecipients($recipients)
            ->setSendoptions($sendoptions);
    }
    /**
     * Get from value
     * @return \StructType\From|null
     */
    public function getFrom()
    {
        return $this->from;
    }
    /**
     * Set from value
     * @param \StructType\From $from
     * @return \StructType\Distribution
     */
    public function setFrom(\StructType\From $from = null)
    {
        $this->from = $from;
        return $this;
    }
    /**
     * Get to value
     * @return string|null
     */
    public function getTo()
    {
        return $this->to;
    }
    /**
     * Set to value
     * @param string $to
     * @return \StructType\Distribution
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($to)), __LINE__);
        }
        $this->to = $to;
        return $this;
    }
    /**
     * Get cc value
     * @return string|null
     */
    public function getCc()
    {
        return $this->cc;
    }
    /**
     * Set cc value
     * @param string $cc
     * @return \StructType\Distribution
     */
    public function setCc($cc = null)
    {
        // validation for constraint: string
        if (!is_null($cc) && !is_string($cc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cc)), __LINE__);
        }
        $this->cc = $cc;
        return $this;
    }
    /**
     * Get bc value
     * @return string|null
     */
    public function getBc()
    {
        return $this->bc;
    }
    /**
     * Set bc value
     * @param string $bc
     * @return \StructType\Distribution
     */
    public function setBc($bc = null)
    {
        // validation for constraint: string
        if (!is_null($bc) && !is_string($bc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bc)), __LINE__);
        }
        $this->bc = $bc;
        return $this;
    }
    /**
     * Get recipients value
     * @return \StructType\RecipientList|null
     */
    public function getRecipients()
    {
        return $this->recipients;
    }
    /**
     * Set recipients value
     * @param \StructType\RecipientList $recipients
     * @return \StructType\Distribution
     */
    public function setRecipients(\StructType\RecipientList $recipients = null)
    {
        $this->recipients = $recipients;
        return $this;
    }
    /**
     * Get sendoptions value
     * @return \StructType\SendOptions|null
     */
    public function getSendoptions()
    {
        return $this->sendoptions;
    }
    /**
     * Set sendoptions value
     * @param \StructType\SendOptions $sendoptions
     * @return \StructType\Distribution
     */
    public function setSendoptions(\StructType\SendOptions $sendoptions = null)
    {
        $this->sendoptions = $sendoptions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Distribution
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
