<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DisplaySettingsList StructType
 * @subpackage Structs
 */
class DisplaySettingsList extends AbstractStructBase
{
    /**
     * The settings
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DisplaySettings[]
     */
    public $settings;
    /**
     * Constructor method for DisplaySettingsList
     * @uses DisplaySettingsList::setSettings()
     * @param \StructType\DisplaySettings[] $settings
     */
    public function __construct(array $settings = array())
    {
        $this
            ->setSettings($settings);
    }
    /**
     * Get settings value
     * @return \StructType\DisplaySettings[]|null
     */
    public function getSettings()
    {
        return $this->settings;
    }
    /**
     * Set settings value
     * @throws \InvalidArgumentException
     * @param \StructType\DisplaySettings[] $settings
     * @return \StructType\DisplaySettingsList
     */
    public function setSettings(array $settings = array())
    {
        foreach ($settings as $displaySettingsListSettingsItem) {
            // validation for constraint: itemType
            if (!$displaySettingsListSettingsItem instanceof \StructType\DisplaySettings) {
                throw new \InvalidArgumentException(sprintf('The settings property can only contain items of \StructType\DisplaySettings, "%s" given', is_object($displaySettingsListSettingsItem) ? get_class($displaySettingsListSettingsItem) : gettype($displaySettingsListSettingsItem)), __LINE__);
            }
        }
        $this->settings = $settings;
        return $this;
    }
    /**
     * Add item to settings value
     * @throws \InvalidArgumentException
     * @param \StructType\DisplaySettings $item
     * @return \StructType\DisplaySettingsList
     */
    public function addToSettings(\StructType\DisplaySettings $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DisplaySettings) {
            throw new \InvalidArgumentException(sprintf('The settings property can only contain items of \StructType\DisplaySettings, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->settings[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DisplaySettingsList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
