<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DisplaySettings StructType
 * @subpackage Structs
 */
class DisplaySettings extends Item
{
    /**
     * The folderType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $folderType;
    /**
     * The settingType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $settingType;
    /**
     * The flags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DisplayFlags
     */
    public $flags;
    /**
     * The types
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $types;
    /**
     * The source
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * The view
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $view;
    /**
     * The columns
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\ColumnSettings[]
     */
    public $columns;
    /**
     * The filterDaysForward
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $filterDaysForward;
    /**
     * The filterDaysBackward
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $filterDaysBackward;
    /**
     * Constructor method for DisplaySettings
     * @uses DisplaySettings::setFolderType()
     * @uses DisplaySettings::setSettingType()
     * @uses DisplaySettings::setFlags()
     * @uses DisplaySettings::setTypes()
     * @uses DisplaySettings::setSource()
     * @uses DisplaySettings::setView()
     * @uses DisplaySettings::setColumns()
     * @uses DisplaySettings::setFilterDaysForward()
     * @uses DisplaySettings::setFilterDaysBackward()
     * @param string $folderType
     * @param string $settingType
     * @param \StructType\DisplayFlags $flags
     * @param string $types
     * @param string $source
     * @param string $view
     * @param \StructType\ColumnSettings[] $columns
     * @param int $filterDaysForward
     * @param int $filterDaysBackward
     */
    public function __construct($folderType = null, $settingType = null, \StructType\DisplayFlags $flags = null, $types = null, $source = null, $view = null, array $columns = array(), $filterDaysForward = null, $filterDaysBackward = null)
    {
        $this
            ->setFolderType($folderType)
            ->setSettingType($settingType)
            ->setFlags($flags)
            ->setTypes($types)
            ->setSource($source)
            ->setView($view)
            ->setColumns($columns)
            ->setFilterDaysForward($filterDaysForward)
            ->setFilterDaysBackward($filterDaysBackward);
    }
    /**
     * Get folderType value
     * @return string|null
     */
    public function getFolderType()
    {
        return $this->folderType;
    }
    /**
     * Set folderType value
     * @uses \EnumType\DisplayFolderType::valueIsValid()
     * @uses \EnumType\DisplayFolderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $folderType
     * @return \StructType\DisplaySettings
     */
    public function setFolderType($folderType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DisplayFolderType::valueIsValid($folderType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $folderType, implode(', ', \EnumType\DisplayFolderType::getValidValues())), __LINE__);
        }
        $this->folderType = $folderType;
        return $this;
    }
    /**
     * Get settingType value
     * @return string|null
     */
    public function getSettingType()
    {
        return $this->settingType;
    }
    /**
     * Set settingType value
     * @uses \EnumType\DisplaySettingsType::valueIsValid()
     * @uses \EnumType\DisplaySettingsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $settingType
     * @return \StructType\DisplaySettings
     */
    public function setSettingType($settingType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DisplaySettingsType::valueIsValid($settingType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $settingType, implode(', ', \EnumType\DisplaySettingsType::getValidValues())), __LINE__);
        }
        $this->settingType = $settingType;
        return $this;
    }
    /**
     * Get flags value
     * @return \StructType\DisplayFlags|null
     */
    public function getFlags()
    {
        return $this->flags;
    }
    /**
     * Set flags value
     * @param \StructType\DisplayFlags $flags
     * @return \StructType\DisplaySettings
     */
    public function setFlags(\StructType\DisplayFlags $flags = null)
    {
        $this->flags = $flags;
        return $this;
    }
    /**
     * Get types value
     * @return string|null
     */
    public function getTypes()
    {
        return $this->types;
    }
    /**
     * Set types value
     * @param string $types
     * @return \StructType\DisplaySettings
     */
    public function setTypes($types = null)
    {
        // validation for constraint: string
        if (!is_null($types) && !is_string($types)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($types)), __LINE__);
        }
        $this->types = $types;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \StructType\DisplaySettings
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get view value
     * @return string|null
     */
    public function getView()
    {
        return $this->view;
    }
    /**
     * Set view value
     * @uses \EnumType\ViewType::valueIsValid()
     * @uses \EnumType\ViewType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $view
     * @return \StructType\DisplaySettings
     */
    public function setView($view = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ViewType::valueIsValid($view)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $view, implode(', ', \EnumType\ViewType::getValidValues())), __LINE__);
        }
        $this->view = $view;
        return $this;
    }
    /**
     * Get columns value
     * @return \StructType\ColumnSettings[]|null
     */
    public function getColumns()
    {
        return $this->columns;
    }
    /**
     * Set columns value
     * @throws \InvalidArgumentException
     * @param \StructType\ColumnSettings[] $columns
     * @return \StructType\DisplaySettings
     */
    public function setColumns(array $columns = array())
    {
        foreach ($columns as $displaySettingsColumnsItem) {
            // validation for constraint: itemType
            if (!$displaySettingsColumnsItem instanceof \StructType\ColumnSettings) {
                throw new \InvalidArgumentException(sprintf('The columns property can only contain items of \StructType\ColumnSettings, "%s" given', is_object($displaySettingsColumnsItem) ? get_class($displaySettingsColumnsItem) : gettype($displaySettingsColumnsItem)), __LINE__);
            }
        }
        $this->columns = $columns;
        return $this;
    }
    /**
     * Add item to columns value
     * @throws \InvalidArgumentException
     * @param \StructType\ColumnSettings $item
     * @return \StructType\DisplaySettings
     */
    public function addToColumns(\StructType\ColumnSettings $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ColumnSettings) {
            throw new \InvalidArgumentException(sprintf('The columns property can only contain items of \StructType\ColumnSettings, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->columns[] = $item;
        return $this;
    }
    /**
     * Get filterDaysForward value
     * @return int|null
     */
    public function getFilterDaysForward()
    {
        return $this->filterDaysForward;
    }
    /**
     * Set filterDaysForward value
     * @param int $filterDaysForward
     * @return \StructType\DisplaySettings
     */
    public function setFilterDaysForward($filterDaysForward = null)
    {
        // validation for constraint: int
        if (!is_null($filterDaysForward) && !is_numeric($filterDaysForward)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($filterDaysForward)), __LINE__);
        }
        $this->filterDaysForward = $filterDaysForward;
        return $this;
    }
    /**
     * Get filterDaysBackward value
     * @return int|null
     */
    public function getFilterDaysBackward()
    {
        return $this->filterDaysBackward;
    }
    /**
     * Set filterDaysBackward value
     * @param int $filterDaysBackward
     * @return \StructType\DisplaySettings
     */
    public function setFilterDaysBackward($filterDaysBackward = null)
    {
        // validation for constraint: int
        if (!is_null($filterDaysBackward) && !is_numeric($filterDaysBackward)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($filterDaysBackward)), __LINE__);
        }
        $this->filterDaysBackward = $filterDaysBackward;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DisplaySettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
