<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeltaInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: The deltaInfo structure contains pointers or sequence numbers into a dynamic list. count: Input: The desired number of items to be returned in one read. A count of "-1" means to return all the items in the list. If omitted, all the
 * items are returned. Output: The actual number of items returned. firstSequence: Input: The sequence or position to start the read. Output: The first valid sequence in the list. lastSequence: Input: N/A Output: The last sequence number successfully
 * read. lastTimePORebuild: The last time the administrator rebuilt the post office. A post office rebuild resets all the sequence numbers. If a rebuild occurs, a resync is required before new deltas can be applied to a local list.
 * @subpackage Structs
 */
class DeltaInfo extends AbstractStructBase
{
    /**
     * The count
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $count;
    /**
     * The firstSequence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $firstSequence;
    /**
     * The lastSequence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $lastSequence;
    /**
     * The lastTimePORebuild
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $lastTimePORebuild;
    /**
     * Constructor method for DeltaInfo
     * @uses DeltaInfo::setCount()
     * @uses DeltaInfo::setFirstSequence()
     * @uses DeltaInfo::setLastSequence()
     * @uses DeltaInfo::setLastTimePORebuild()
     * @param int $count
     * @param int $firstSequence
     * @param int $lastSequence
     * @param int $lastTimePORebuild
     */
    public function __construct($count = null, $firstSequence = null, $lastSequence = null, $lastTimePORebuild = null)
    {
        $this
            ->setCount($count)
            ->setFirstSequence($firstSequence)
            ->setLastSequence($lastSequence)
            ->setLastTimePORebuild($lastTimePORebuild);
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\DeltaInfo
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !is_numeric($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get firstSequence value
     * @return int|null
     */
    public function getFirstSequence()
    {
        return $this->firstSequence;
    }
    /**
     * Set firstSequence value
     * @param int $firstSequence
     * @return \StructType\DeltaInfo
     */
    public function setFirstSequence($firstSequence = null)
    {
        // validation for constraint: int
        if (!is_null($firstSequence) && !is_numeric($firstSequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($firstSequence)), __LINE__);
        }
        $this->firstSequence = $firstSequence;
        return $this;
    }
    /**
     * Get lastSequence value
     * @return int|null
     */
    public function getLastSequence()
    {
        return $this->lastSequence;
    }
    /**
     * Set lastSequence value
     * @param int $lastSequence
     * @return \StructType\DeltaInfo
     */
    public function setLastSequence($lastSequence = null)
    {
        // validation for constraint: int
        if (!is_null($lastSequence) && !is_numeric($lastSequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lastSequence)), __LINE__);
        }
        $this->lastSequence = $lastSequence;
        return $this;
    }
    /**
     * Get lastTimePORebuild value
     * @return int|null
     */
    public function getLastTimePORebuild()
    {
        return $this->lastTimePORebuild;
    }
    /**
     * Set lastTimePORebuild value
     * @param int $lastTimePORebuild
     * @return \StructType\DeltaInfo
     */
    public function setLastTimePORebuild($lastTimePORebuild = null)
    {
        // validation for constraint: int
        if (!is_null($lastTimePORebuild) && !is_numeric($lastTimePORebuild)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lastTimePORebuild)), __LINE__);
        }
        $this->lastTimePORebuild = $lastTimePORebuild;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeltaInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
