<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DayOfYearList StructType
 * @subpackage Structs
 */
class DayOfYearList extends AbstractStructBase
{
    /**
     * The day
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxInclusive: 366
     * - minInclusive: -366
     * @var int[]
     */
    public $day;
    /**
     * Constructor method for DayOfYearList
     * @uses DayOfYearList::setDay()
     * @param int[] $day
     */
    public function __construct(array $day = array())
    {
        $this
            ->setDay($day);
    }
    /**
     * Get day value
     * @return int[]|null
     */
    public function getDay()
    {
        return $this->day;
    }
    /**
     * Set day value
     * @throws \InvalidArgumentException
     * @param int[] $day
     * @return \StructType\DayOfYearList
     */
    public function setDay(array $day = array())
    {
        // validation for constraint: maxInclusive
        if ($day > 366) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 366, "%s" given', $day), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($day < -366) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -366, "%s" given', $day), __LINE__);
        }
        foreach ($day as $dayOfYearListDayItem) {
            // validation for constraint: itemType
            if (!is_numeric($dayOfYearListDayItem)) {
                throw new \InvalidArgumentException(sprintf('The day property can only contain items of short, "%s" given', is_object($dayOfYearListDayItem) ? get_class($dayOfYearListDayItem) : gettype($dayOfYearListDayItem)), __LINE__);
            }
        }
        $this->day = $day;
        return $this;
    }
    /**
     * Add item to day value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\DayOfYearList
     */
    public function addToDay($item)
    {
        // validation for constraint: maxInclusive
        if ($item > 366) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 366, "%s" given', $item), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($item < -366) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -366, "%s" given', $item), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The day property can only contain items of short, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->day[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DayOfYearList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
