<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DayOfMonthList StructType
 * @subpackage Structs
 */
class DayOfMonthList extends AbstractStructBase
{
    /**
     * The day
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxInclusive: 31
     * - minInclusive: -31
     * @var string[]
     */
    public $day;
    /**
     * Constructor method for DayOfMonthList
     * @uses DayOfMonthList::setDay()
     * @param string[] $day
     */
    public function __construct(array $day = array())
    {
        $this
            ->setDay($day);
    }
    /**
     * Get day value
     * @return string[]|null
     */
    public function getDay()
    {
        return $this->day;
    }
    /**
     * Set day value
     * @throws \InvalidArgumentException
     * @param string[] $day
     * @return \StructType\DayOfMonthList
     */
    public function setDay(array $day = array())
    {
        // validation for constraint: maxInclusive
        if ($day > 31) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 31, "%s" given', $day), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($day < -31) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -31, "%s" given', $day), __LINE__);
        }
        foreach ($day as $dayOfMonthListDayItem) {
            // validation for constraint: itemType
            if (!is_string($dayOfMonthListDayItem)) {
                throw new \InvalidArgumentException(sprintf('The day property can only contain items of byte, "%s" given', is_object($dayOfMonthListDayItem) ? get_class($dayOfMonthListDayItem) : gettype($dayOfMonthListDayItem)), __LINE__);
            }
        }
        $this->day = $day;
        return $this;
    }
    /**
     * Add item to day value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DayOfMonthList
     */
    public function addToDay($item)
    {
        // validation for constraint: maxInclusive
        if ($item > 31) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 31, "%s" given', $item), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($item < -31) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -31, "%s" given', $item), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The day property can only contain items of byte, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->day[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DayOfMonthList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
