<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomList StructType
 * @subpackage Structs
 */
class CustomList extends AbstractStructBase
{
    /**
     * The custom
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Custom[]
     */
    public $custom;
    /**
     * Constructor method for CustomList
     * @uses CustomList::setCustom()
     * @param \StructType\Custom[] $custom
     */
    public function __construct(array $custom = array())
    {
        $this
            ->setCustom($custom);
    }
    /**
     * Get custom value
     * @return \StructType\Custom[]|null
     */
    public function getCustom()
    {
        return $this->custom;
    }
    /**
     * Set custom value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom[] $custom
     * @return \StructType\CustomList
     */
    public function setCustom(array $custom = array())
    {
        foreach ($custom as $customListCustomItem) {
            // validation for constraint: itemType
            if (!$customListCustomItem instanceof \StructType\Custom) {
                throw new \InvalidArgumentException(sprintf('The custom property can only contain items of \StructType\Custom, "%s" given', is_object($customListCustomItem) ? get_class($customListCustomItem) : gettype($customListCustomItem)), __LINE__);
            }
        }
        $this->custom = $custom;
        return $this;
    }
    /**
     * Add item to custom value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom $item
     * @return \StructType\CustomList
     */
    public function addToCustom(\StructType\Custom $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Custom) {
            throw new \InvalidArgumentException(sprintf('The custom property can only contain items of \StructType\Custom, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->custom[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
