<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createItemResponse StructType
 * @subpackage Structs
 */
class CreateItemResponse extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string[]
     */
    public $id;
    /**
     * The status
     * @var \StructType\Status
     */
    public $status;
    /**
     * Constructor method for createItemResponse
     * @uses CreateItemResponse::setId()
     * @uses CreateItemResponse::setStatus()
     * @param string[] $id
     * @param \StructType\Status $status
     */
    public function __construct(array $id = array(), \StructType\Status $status = null)
    {
        $this
            ->setId($id)
            ->setStatus($status);
    }
    /**
     * Get id value
     * @return string[]
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @throws \InvalidArgumentException
     * @param string[] $id
     * @return \StructType\CreateItemResponse
     */
    public function setId(array $id = array())
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[^@]+(@*)?/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($id, true)), __LINE__);
        }
        foreach ($id as $createItemResponseIdItem) {
            // validation for constraint: itemType
            if (!is_string($createItemResponseIdItem)) {
                throw new \InvalidArgumentException(sprintf('The id property can only contain items of string, "%s" given', is_object($createItemResponseIdItem) ? get_class($createItemResponseIdItem) : gettype($createItemResponseIdItem)), __LINE__);
            }
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Add item to id value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CreateItemResponse
     */
    public function addToId($item)
    {
        // validation for constraint: pattern
        if (is_scalar($item) && !preg_match('/[^@]+(@*)?/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($item, true)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The id property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->id[] = $item;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\CreateItemResponse
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateItemResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
