<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createItemRequest StructType
 * @subpackage Structs
 */
class CreateItemRequest extends AbstractStructBase
{
    /**
     * The item
     * @var \StructType\Item
     */
    public $item;
    /**
     * The notification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SharedFolderNotification
     */
    public $notification;
    /**
     * The view
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $view;
    /**
     * Constructor method for createItemRequest
     * @uses CreateItemRequest::setItem()
     * @uses CreateItemRequest::setNotification()
     * @uses CreateItemRequest::setView()
     * @param \StructType\Item $item
     * @param \StructType\SharedFolderNotification $notification
     * @param string $view
     */
    public function __construct(\StructType\Item $item = null, \StructType\SharedFolderNotification $notification = null, $view = null)
    {
        $this
            ->setItem($item)
            ->setNotification($notification)
            ->setView($view);
    }
    /**
     * Get item value
     * @return \StructType\Item|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\Item $item
     * @return \StructType\CreateItemRequest
     */
    public function setItem(\StructType\Item $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get notification value
     * @return \StructType\SharedFolderNotification|null
     */
    public function getNotification()
    {
        return $this->notification;
    }
    /**
     * Set notification value
     * @param \StructType\SharedFolderNotification $notification
     * @return \StructType\CreateItemRequest
     */
    public function setNotification(\StructType\SharedFolderNotification $notification = null)
    {
        $this->notification = $notification;
        return $this;
    }
    /**
     * Get view value
     * @return string|null
     */
    public function getView()
    {
        return $this->view;
    }
    /**
     * Set view value
     * @param string $view
     * @return \StructType\CreateItemRequest
     */
    public function setView($view = null)
    {
        // validation for constraint: string
        if (!is_null($view) && !is_string($view)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($view)), __LINE__);
        }
        $this->view = $view;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateItemRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
