<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactRefList StructType
 * @subpackage Structs
 */
class ContactRefList extends AbstractStructBase
{
    /**
     * The contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string[]
     */
    public $contact;
    /**
     * Constructor method for ContactRefList
     * @uses ContactRefList::setContact()
     * @param string[] $contact
     */
    public function __construct(array $contact = array())
    {
        $this
            ->setContact($contact);
    }
    /**
     * Get contact value
     * @return string[]
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @throws \InvalidArgumentException
     * @param string[] $contact
     * @return \StructType\ContactRefList
     */
    public function setContact(array $contact = array())
    {
        // validation for constraint: pattern
        if (is_scalar($contact) && !preg_match('/[^@]+(@*)?/', $contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($contact, true)), __LINE__);
        }
        foreach ($contact as $contactRefListContactItem) {
            // validation for constraint: itemType
            if (!is_string($contactRefListContactItem)) {
                throw new \InvalidArgumentException(sprintf('The contact property can only contain items of string, "%s" given', is_object($contactRefListContactItem) ? get_class($contactRefListContactItem) : gettype($contactRefListContactItem)), __LINE__);
            }
        }
        $this->contact = $contact;
        return $this;
    }
    /**
     * Add item to contact value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ContactRefList
     */
    public function addToContact($item)
    {
        // validation for constraint: pattern
        if (is_scalar($item) && !preg_match('/[^@]+(@*)?/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($item, true)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The contact property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->contact[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContactRefList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
