<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contact StructType
 * @subpackage Structs
 */
class Contact extends AddressBookItem
{
    /**
     * The fullName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FullName
     */
    public $fullName;
    /**
     * The emailList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmailAddressList
     */
    public $emailList;
    /**
     * The imList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ImAddressList
     */
    public $imList;
    /**
     * The phoneList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PhoneList
     */
    public $phoneList;
    /**
     * The addressList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PostalAddressList
     */
    public $addressList;
    /**
     * The officeInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OfficeInfo
     */
    public $officeInfo;
    /**
     * The personalInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PersonalInfo
     */
    public $personalInfo;
    /**
     * The referenceInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReferenceInfo
     */
    public $referenceInfo;
    /**
     * The advancedInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdvancedInfo
     */
    public $advancedInfo;
    /**
     * The contactNotes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ContactNotes
     */
    public $contactNotes;
    /**
     * The vcard
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AttachmentItemInfo
     */
    public $vcard;
    /**
     * Constructor method for Contact
     * @uses Contact::setFullName()
     * @uses Contact::setEmailList()
     * @uses Contact::setImList()
     * @uses Contact::setPhoneList()
     * @uses Contact::setAddressList()
     * @uses Contact::setOfficeInfo()
     * @uses Contact::setPersonalInfo()
     * @uses Contact::setReferenceInfo()
     * @uses Contact::setAdvancedInfo()
     * @uses Contact::setContactNotes()
     * @uses Contact::setVcard()
     * @param \StructType\FullName $fullName
     * @param \StructType\EmailAddressList $emailList
     * @param \StructType\ImAddressList $imList
     * @param \StructType\PhoneList $phoneList
     * @param \StructType\PostalAddressList $addressList
     * @param \StructType\OfficeInfo $officeInfo
     * @param \StructType\PersonalInfo $personalInfo
     * @param \StructType\ReferenceInfo $referenceInfo
     * @param \StructType\AdvancedInfo $advancedInfo
     * @param \StructType\ContactNotes $contactNotes
     * @param \StructType\AttachmentItemInfo $vcard
     */
    public function __construct(\StructType\FullName $fullName = null, \StructType\EmailAddressList $emailList = null, \StructType\ImAddressList $imList = null, \StructType\PhoneList $phoneList = null, \StructType\PostalAddressList $addressList = null, \StructType\OfficeInfo $officeInfo = null, \StructType\PersonalInfo $personalInfo = null, \StructType\ReferenceInfo $referenceInfo = null, \StructType\AdvancedInfo $advancedInfo = null, \StructType\ContactNotes $contactNotes = null, \StructType\AttachmentItemInfo $vcard = null)
    {
        $this
            ->setFullName($fullName)
            ->setEmailList($emailList)
            ->setImList($imList)
            ->setPhoneList($phoneList)
            ->setAddressList($addressList)
            ->setOfficeInfo($officeInfo)
            ->setPersonalInfo($personalInfo)
            ->setReferenceInfo($referenceInfo)
            ->setAdvancedInfo($advancedInfo)
            ->setContactNotes($contactNotes)
            ->setVcard($vcard);
    }
    /**
     * Get fullName value
     * @return \StructType\FullName|null
     */
    public function getFullName()
    {
        return $this->fullName;
    }
    /**
     * Set fullName value
     * @param \StructType\FullName $fullName
     * @return \StructType\Contact
     */
    public function setFullName(\StructType\FullName $fullName = null)
    {
        $this->fullName = $fullName;
        return $this;
    }
    /**
     * Get emailList value
     * @return \StructType\EmailAddressList|null
     */
    public function getEmailList()
    {
        return $this->emailList;
    }
    /**
     * Set emailList value
     * @param \StructType\EmailAddressList $emailList
     * @return \StructType\Contact
     */
    public function setEmailList(\StructType\EmailAddressList $emailList = null)
    {
        $this->emailList = $emailList;
        return $this;
    }
    /**
     * Get imList value
     * @return \StructType\ImAddressList|null
     */
    public function getImList()
    {
        return $this->imList;
    }
    /**
     * Set imList value
     * @param \StructType\ImAddressList $imList
     * @return \StructType\Contact
     */
    public function setImList(\StructType\ImAddressList $imList = null)
    {
        $this->imList = $imList;
        return $this;
    }
    /**
     * Get phoneList value
     * @return \StructType\PhoneList|null
     */
    public function getPhoneList()
    {
        return $this->phoneList;
    }
    /**
     * Set phoneList value
     * @param \StructType\PhoneList $phoneList
     * @return \StructType\Contact
     */
    public function setPhoneList(\StructType\PhoneList $phoneList = null)
    {
        $this->phoneList = $phoneList;
        return $this;
    }
    /**
     * Get addressList value
     * @return \StructType\PostalAddressList|null
     */
    public function getAddressList()
    {
        return $this->addressList;
    }
    /**
     * Set addressList value
     * @param \StructType\PostalAddressList $addressList
     * @return \StructType\Contact
     */
    public function setAddressList(\StructType\PostalAddressList $addressList = null)
    {
        $this->addressList = $addressList;
        return $this;
    }
    /**
     * Get officeInfo value
     * @return \StructType\OfficeInfo|null
     */
    public function getOfficeInfo()
    {
        return $this->officeInfo;
    }
    /**
     * Set officeInfo value
     * @param \StructType\OfficeInfo $officeInfo
     * @return \StructType\Contact
     */
    public function setOfficeInfo(\StructType\OfficeInfo $officeInfo = null)
    {
        $this->officeInfo = $officeInfo;
        return $this;
    }
    /**
     * Get personalInfo value
     * @return \StructType\PersonalInfo|null
     */
    public function getPersonalInfo()
    {
        return $this->personalInfo;
    }
    /**
     * Set personalInfo value
     * @param \StructType\PersonalInfo $personalInfo
     * @return \StructType\Contact
     */
    public function setPersonalInfo(\StructType\PersonalInfo $personalInfo = null)
    {
        $this->personalInfo = $personalInfo;
        return $this;
    }
    /**
     * Get referenceInfo value
     * @return \StructType\ReferenceInfo|null
     */
    public function getReferenceInfo()
    {
        return $this->referenceInfo;
    }
    /**
     * Set referenceInfo value
     * @param \StructType\ReferenceInfo $referenceInfo
     * @return \StructType\Contact
     */
    public function setReferenceInfo(\StructType\ReferenceInfo $referenceInfo = null)
    {
        $this->referenceInfo = $referenceInfo;
        return $this;
    }
    /**
     * Get advancedInfo value
     * @return \StructType\AdvancedInfo|null
     */
    public function getAdvancedInfo()
    {
        return $this->advancedInfo;
    }
    /**
     * Set advancedInfo value
     * @param \StructType\AdvancedInfo $advancedInfo
     * @return \StructType\Contact
     */
    public function setAdvancedInfo(\StructType\AdvancedInfo $advancedInfo = null)
    {
        $this->advancedInfo = $advancedInfo;
        return $this;
    }
    /**
     * Get contactNotes value
     * @return \StructType\ContactNotes|null
     */
    public function getContactNotes()
    {
        return $this->contactNotes;
    }
    /**
     * Set contactNotes value
     * @param \StructType\ContactNotes $contactNotes
     * @return \StructType\Contact
     */
    public function setContactNotes(\StructType\ContactNotes $contactNotes = null)
    {
        $this->contactNotes = $contactNotes;
        return $this;
    }
    /**
     * Get vcard value
     * @return \StructType\AttachmentItemInfo|null
     */
    public function getVcard()
    {
        return $this->vcard;
    }
    /**
     * Set vcard value
     * @param \StructType\AttachmentItemInfo $vcard
     * @return \StructType\Contact
     */
    public function setVcard(\StructType\AttachmentItemInfo $vcard = null)
    {
        $this->vcard = $vcard;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Contact
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
