<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CategoryRefList StructType
 * @subpackage Structs
 */
class CategoryRefList extends AbstractStructBase
{
    /**
     * The category
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string[]
     */
    public $category;
    /**
     * The primary
     * Meta informations extracted from the WSDL
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - minOccurs: 0
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $primary;
    /**
     * Constructor method for CategoryRefList
     * @uses CategoryRefList::setCategory()
     * @uses CategoryRefList::setPrimary()
     * @param string[] $category
     * @param string $primary
     */
    public function __construct(array $category = array(), $primary = null)
    {
        $this
            ->setCategory($category)
            ->setPrimary($primary);
    }
    /**
     * Get category value
     * @return string[]
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @throws \InvalidArgumentException
     * @param string[] $category
     * @return \StructType\CategoryRefList
     */
    public function setCategory(array $category = array())
    {
        // validation for constraint: pattern
        if (is_scalar($category) && !preg_match('/[^@]+(@*)?/', $category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($category, true)), __LINE__);
        }
        foreach ($category as $categoryRefListCategoryItem) {
            // validation for constraint: itemType
            if (!is_string($categoryRefListCategoryItem)) {
                throw new \InvalidArgumentException(sprintf('The category property can only contain items of string, "%s" given', is_object($categoryRefListCategoryItem) ? get_class($categoryRefListCategoryItem) : gettype($categoryRefListCategoryItem)), __LINE__);
            }
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Add item to category value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CategoryRefList
     */
    public function addToCategory($item)
    {
        // validation for constraint: pattern
        if (is_scalar($item) && !preg_match('/[^@]+(@*)?/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($item, true)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The category property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->category[] = $item;
        return $this;
    }
    /**
     * Get primary value
     * @return string|null
     */
    public function getPrimary()
    {
        return $this->primary;
    }
    /**
     * Set primary value
     * @param string $primary
     * @return \StructType\CategoryRefList
     */
    public function setPrimary($primary = null)
    {
        // validation for constraint: pattern
        if (is_scalar($primary) && !preg_match('/[^@]+(@*)?/', $primary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($primary, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($primary) && !is_string($primary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primary)), __LINE__);
        }
        $this->primary = $primary;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CategoryRefList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
