<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Category StructType
 * @subpackage Structs
 */
class Category extends Item
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The color
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $color;
    /**
     * The background
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $background;
    /**
     * The flags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CategoryFlags
     */
    public $flags;
    /**
     * Constructor method for Category
     * @uses Category::setType()
     * @uses Category::setColor()
     * @uses Category::setBackground()
     * @uses Category::setFlags()
     * @param string $type
     * @param int $color
     * @param int $background
     * @param \StructType\CategoryFlags $flags
     */
    public function __construct($type = null, $color = null, $background = null, \StructType\CategoryFlags $flags = null)
    {
        $this
            ->setType($type)
            ->setColor($color)
            ->setBackground($background)
            ->setFlags($flags);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\CategoryType::valueIsValid()
     * @uses \EnumType\CategoryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\Category
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CategoryType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\CategoryType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get color value
     * @return int|null
     */
    public function getColor()
    {
        return $this->color;
    }
    /**
     * Set color value
     * @param int $color
     * @return \StructType\Category
     */
    public function setColor($color = null)
    {
        // validation for constraint: int
        if (!is_null($color) && !is_numeric($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($color)), __LINE__);
        }
        $this->color = $color;
        return $this;
    }
    /**
     * Get background value
     * @return int|null
     */
    public function getBackground()
    {
        return $this->background;
    }
    /**
     * Set background value
     * @param int $background
     * @return \StructType\Category
     */
    public function setBackground($background = null)
    {
        // validation for constraint: int
        if (!is_null($background) && !is_numeric($background)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($background)), __LINE__);
        }
        $this->background = $background;
        return $this;
    }
    /**
     * Get flags value
     * @return \StructType\CategoryFlags|null
     */
    public function getFlags()
    {
        return $this->flags;
    }
    /**
     * Set flags value
     * @param \StructType\CategoryFlags $flags
     * @return \StructType\Category
     */
    public function setFlags(\StructType\CategoryFlags $flags = null)
    {
        $this->flags = $flags;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Category
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
