<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalendarFolderAttribute StructType
 * @subpackage Structs
 */
class CalendarFolderAttribute extends AbstractStructBase
{
    /**
     * The flags
     * Meta informations extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var string[]
     */
    public $flags;
    /**
     * The color
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $color;
    /**
     * The calSequence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $calSequence;
    /**
     * The publish
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CalendarPublish
     */
    public $publish;
    /**
     * Constructor method for CalendarFolderAttribute
     * @uses CalendarFolderAttribute::setFlags()
     * @uses CalendarFolderAttribute::setColor()
     * @uses CalendarFolderAttribute::setCalSequence()
     * @uses CalendarFolderAttribute::setPublish()
     * @param string[] $flags
     * @param int $color
     * @param int $calSequence
     * @param \StructType\CalendarPublish $publish
     */
    public function __construct(array $flags = array(), $color = null, $calSequence = null, \StructType\CalendarPublish $publish = null)
    {
        $this
            ->setFlags($flags)
            ->setColor($color)
            ->setCalSequence($calSequence)
            ->setPublish($publish);
    }
    /**
     * Get flags value
     * @return string[]|null
     */
    public function getFlags()
    {
        return $this->flags;
    }
    /**
     * Set flags value
     * @uses \EnumType\CalendarFolderFlags::valueIsValid()
     * @uses \EnumType\CalendarFolderFlags::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $flags
     * @return \StructType\CalendarFolderAttribute
     */
    public function setFlags(array $flags = array())
    {
        $invalidValues = array();
        foreach ($flags as $calendarFolderAttributeFlagsItem) {
            if (!\EnumType\CalendarFolderFlags::valueIsValid($calendarFolderAttributeFlagsItem)) {
                $invalidValues[] = var_export($calendarFolderAttributeFlagsItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\CalendarFolderFlags::getValidValues())), __LINE__);
        }
        $this->flags = $flags;
        return $this;
    }
    /**
     * Add item to flags value
     * @uses \EnumType\CalendarFolderFlags::valueIsValid()
     * @uses \EnumType\CalendarFolderFlags::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CalendarFolderAttribute
     */
    public function addToFlags($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CalendarFolderFlags::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\CalendarFolderFlags::getValidValues())), __LINE__);
        }
        $this->flags[] = $item;
        return $this;
    }
    /**
     * Get color value
     * @return int|null
     */
    public function getColor()
    {
        return $this->color;
    }
    /**
     * Set color value
     * @param int $color
     * @return \StructType\CalendarFolderAttribute
     */
    public function setColor($color = null)
    {
        // validation for constraint: int
        if (!is_null($color) && !is_numeric($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($color)), __LINE__);
        }
        $this->color = $color;
        return $this;
    }
    /**
     * Get calSequence value
     * @return int|null
     */
    public function getCalSequence()
    {
        return $this->calSequence;
    }
    /**
     * Set calSequence value
     * @param int $calSequence
     * @return \StructType\CalendarFolderAttribute
     */
    public function setCalSequence($calSequence = null)
    {
        // validation for constraint: int
        if (!is_null($calSequence) && !is_numeric($calSequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($calSequence)), __LINE__);
        }
        $this->calSequence = $calSequence;
        return $this;
    }
    /**
     * Get publish value
     * @return \StructType\CalendarPublish|null
     */
    public function getPublish()
    {
        return $this->publish;
    }
    /**
     * Set publish value
     * @param \StructType\CalendarPublish $publish
     * @return \StructType\CalendarFolderAttribute
     */
    public function setPublish(\StructType\CalendarPublish $publish = null)
    {
        $this->publish = $publish;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CalendarFolderAttribute
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
