<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BoxEntry StructType
 * Meta informations extracted from the WSDL
 * - documentation: Return the sent items id if this returnSentItemsId is true. The returnSentItemsId will be the first id returned in the list. This is the id of the item that is created in the sent items (a.k.a. outbox, itemSource=sent) folder.
 * @subpackage Structs
 */
class BoxEntry extends ContainerItem
{
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemStatus
     */
    public $status;
    /**
     * The msgId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $msgId;
    /**
     * The messageId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $messageId;
    /**
     * The clientMessageId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $clientMessageId;
    /**
     * The source
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * The returnSentItemsId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $returnSentItemsId;
    /**
     * The delivered
     * @var string
     */
    public $delivered;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The security
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $security;
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The viewExternalHTMLImages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $viewExternalHTMLImages;
    /**
     * Constructor method for BoxEntry
     * @uses BoxEntry::setStatus()
     * @uses BoxEntry::setMsgId()
     * @uses BoxEntry::setMessageId()
     * @uses BoxEntry::setClientMessageId()
     * @uses BoxEntry::setSource()
     * @uses BoxEntry::setReturnSentItemsId()
     * @uses BoxEntry::setDelivered()
     * @uses BoxEntry::setClass()
     * @uses BoxEntry::setSecurity()
     * @uses BoxEntry::setComment()
     * @uses BoxEntry::setViewExternalHTMLImages()
     * @param \StructType\ItemStatus $status
     * @param string $msgId
     * @param string $messageId
     * @param string $clientMessageId
     * @param string $source
     * @param bool $returnSentItemsId
     * @param string $delivered
     * @param string $class
     * @param string $security
     * @param string $comment
     * @param bool $viewExternalHTMLImages
     */
    public function __construct(\StructType\ItemStatus $status = null, $msgId = null, $messageId = null, $clientMessageId = null, $source = null, $returnSentItemsId = null, $delivered = null, $class = null, $security = null, $comment = null, $viewExternalHTMLImages = null)
    {
        $this
            ->setStatus($status)
            ->setMsgId($msgId)
            ->setMessageId($messageId)
            ->setClientMessageId($clientMessageId)
            ->setSource($source)
            ->setReturnSentItemsId($returnSentItemsId)
            ->setDelivered($delivered)
            ->setClass($class)
            ->setSecurity($security)
            ->setComment($comment)
            ->setViewExternalHTMLImages($viewExternalHTMLImages);
    }
    /**
     * Get status value
     * @return \StructType\ItemStatus|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\ItemStatus $status
     * @return \StructType\BoxEntry
     */
    public function setStatus(\StructType\ItemStatus $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get msgId value
     * @return string|null
     */
    public function getMsgId()
    {
        return $this->msgId;
    }
    /**
     * Set msgId value
     * @param string $msgId
     * @return \StructType\BoxEntry
     */
    public function setMsgId($msgId = null)
    {
        // validation for constraint: string
        if (!is_null($msgId) && !is_string($msgId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($msgId)), __LINE__);
        }
        $this->msgId = $msgId;
        return $this;
    }
    /**
     * Get messageId value
     * @return string|null
     */
    public function getMessageId()
    {
        return $this->messageId;
    }
    /**
     * Set messageId value
     * @param string $messageId
     * @return \StructType\BoxEntry
     */
    public function setMessageId($messageId = null)
    {
        // validation for constraint: string
        if (!is_null($messageId) && !is_string($messageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageId)), __LINE__);
        }
        $this->messageId = $messageId;
        return $this;
    }
    /**
     * Get clientMessageId value
     * @return string|null
     */
    public function getClientMessageId()
    {
        return $this->clientMessageId;
    }
    /**
     * Set clientMessageId value
     * @param string $clientMessageId
     * @return \StructType\BoxEntry
     */
    public function setClientMessageId($clientMessageId = null)
    {
        // validation for constraint: string
        if (!is_null($clientMessageId) && !is_string($clientMessageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientMessageId)), __LINE__);
        }
        $this->clientMessageId = $clientMessageId;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @uses \EnumType\ItemSource::valueIsValid()
     * @uses \EnumType\ItemSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $source
     * @return \StructType\BoxEntry
     */
    public function setSource($source = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemSource::valueIsValid($source)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $source, implode(', ', \EnumType\ItemSource::getValidValues())), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get returnSentItemsId value
     * @return bool|null
     */
    public function getReturnSentItemsId()
    {
        return $this->returnSentItemsId;
    }
    /**
     * Set returnSentItemsId value
     * @param bool $returnSentItemsId
     * @return \StructType\BoxEntry
     */
    public function setReturnSentItemsId($returnSentItemsId = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnSentItemsId) && !is_bool($returnSentItemsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($returnSentItemsId)), __LINE__);
        }
        $this->returnSentItemsId = $returnSentItemsId;
        return $this;
    }
    /**
     * Get delivered value
     * @return string|null
     */
    public function getDelivered()
    {
        return $this->delivered;
    }
    /**
     * Set delivered value
     * @param string $delivered
     * @return \StructType\BoxEntry
     */
    public function setDelivered($delivered = null)
    {
        // validation for constraint: string
        if (!is_null($delivered) && !is_string($delivered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delivered)), __LINE__);
        }
        $this->delivered = $delivered;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \EnumType\ItemClass::valueIsValid()
     * @uses \EnumType\ItemClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \StructType\BoxEntry
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', \EnumType\ItemClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get security value
     * @return string|null
     */
    public function getSecurity()
    {
        return $this->security;
    }
    /**
     * Set security value
     * @uses \EnumType\ItemSecurity::valueIsValid()
     * @uses \EnumType\ItemSecurity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $security
     * @return \StructType\BoxEntry
     */
    public function setSecurity($security = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemSecurity::valueIsValid($security)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $security, implode(', ', \EnumType\ItemSecurity::getValidValues())), __LINE__);
        }
        $this->security = $security;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\BoxEntry
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get viewExternalHTMLImages value
     * @return bool|null
     */
    public function getViewExternalHTMLImages()
    {
        return $this->viewExternalHTMLImages;
    }
    /**
     * Set viewExternalHTMLImages value
     * @param bool $viewExternalHTMLImages
     * @return \StructType\BoxEntry
     */
    public function setViewExternalHTMLImages($viewExternalHTMLImages = null)
    {
        // validation for constraint: boolean
        if (!is_null($viewExternalHTMLImages) && !is_bool($viewExternalHTMLImages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($viewExternalHTMLImages)), __LINE__);
        }
        $this->viewExternalHTMLImages = $viewExternalHTMLImages;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BoxEntry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
