<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttachmentItemInfo StructType
 * @subpackage Structs
 */
class AttachmentItemInfo extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AttachmentID
     */
    public $id;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:name
     * @var string
     */
    public $name;
    /**
     * The charset
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $charset;
    /**
     * The contentId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contentId;
    /**
     * The contentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contentType;
    /**
     * The size
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $size;
    /**
     * The date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $date;
    /**
     * The data
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $data;
    /**
     * The hidden
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $hidden;
    /**
     * The isPersonal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isPersonal;
    /**
     * The hash
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $hash;
    /**
     * Constructor method for AttachmentItemInfo
     * @uses AttachmentItemInfo::setId()
     * @uses AttachmentItemInfo::setName()
     * @uses AttachmentItemInfo::setCharset()
     * @uses AttachmentItemInfo::setContentId()
     * @uses AttachmentItemInfo::setContentType()
     * @uses AttachmentItemInfo::setSize()
     * @uses AttachmentItemInfo::setDate()
     * @uses AttachmentItemInfo::setData()
     * @uses AttachmentItemInfo::setHidden()
     * @uses AttachmentItemInfo::setIsPersonal()
     * @uses AttachmentItemInfo::setHash()
     * @param \StructType\AttachmentID $id
     * @param string $name
     * @param string $charset
     * @param string $contentId
     * @param string $contentType
     * @param int $size
     * @param string $date
     * @param string $data
     * @param bool $hidden
     * @param bool $isPersonal
     * @param string $hash
     */
    public function __construct(\StructType\AttachmentID $id = null, $name = null, $charset = null, $contentId = null, $contentType = null, $size = null, $date = null, $data = null, $hidden = null, $isPersonal = null, $hash = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setCharset($charset)
            ->setContentId($contentId)
            ->setContentType($contentType)
            ->setSize($size)
            ->setDate($date)
            ->setData($data)
            ->setHidden($hidden)
            ->setIsPersonal($isPersonal)
            ->setHash($hash);
    }
    /**
     * Get id value
     * @return \StructType\AttachmentID|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\AttachmentID $id
     * @return \StructType\AttachmentItemInfo
     */
    public function setId(\StructType\AttachmentID $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\AttachmentItemInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get charset value
     * @return string|null
     */
    public function getCharset()
    {
        return $this->charset;
    }
    /**
     * Set charset value
     * @param string $charset
     * @return \StructType\AttachmentItemInfo
     */
    public function setCharset($charset = null)
    {
        // validation for constraint: string
        if (!is_null($charset) && !is_string($charset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($charset)), __LINE__);
        }
        $this->charset = $charset;
        return $this;
    }
    /**
     * Get contentId value
     * @return string|null
     */
    public function getContentId()
    {
        return $this->contentId;
    }
    /**
     * Set contentId value
     * @param string $contentId
     * @return \StructType\AttachmentItemInfo
     */
    public function setContentId($contentId = null)
    {
        // validation for constraint: string
        if (!is_null($contentId) && !is_string($contentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contentId)), __LINE__);
        }
        $this->contentId = $contentId;
        return $this;
    }
    /**
     * Get contentType value
     * @return string|null
     */
    public function getContentType()
    {
        return $this->contentType;
    }
    /**
     * Set contentType value
     * @param string $contentType
     * @return \StructType\AttachmentItemInfo
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: string
        if (!is_null($contentType) && !is_string($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contentType)), __LINE__);
        }
        $this->contentType = $contentType;
        return $this;
    }
    /**
     * Get size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param int $size
     * @return \StructType\AttachmentItemInfo
     */
    public function setSize($size = null)
    {
        // validation for constraint: int
        if (!is_null($size) && !is_numeric($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($size)), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\AttachmentItemInfo
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get data value
     * @return string|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param string $data
     * @return \StructType\AttachmentItemInfo
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($data)), __LINE__);
        }
        $this->data = $data;
        return $this;
    }
    /**
     * Get hidden value
     * @return bool|null
     */
    public function getHidden()
    {
        return $this->hidden;
    }
    /**
     * Set hidden value
     * @param bool $hidden
     * @return \StructType\AttachmentItemInfo
     */
    public function setHidden($hidden = null)
    {
        // validation for constraint: boolean
        if (!is_null($hidden) && !is_bool($hidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hidden)), __LINE__);
        }
        $this->hidden = $hidden;
        return $this;
    }
    /**
     * Get isPersonal value
     * @return bool|null
     */
    public function getIsPersonal()
    {
        return $this->isPersonal;
    }
    /**
     * Set isPersonal value
     * @param bool $isPersonal
     * @return \StructType\AttachmentItemInfo
     */
    public function setIsPersonal($isPersonal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPersonal) && !is_bool($isPersonal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPersonal)), __LINE__);
        }
        $this->isPersonal = $isPersonal;
        return $this;
    }
    /**
     * Get hash value
     * @return string|null
     */
    public function getHash()
    {
        return $this->hash;
    }
    /**
     * Set hash value
     * @param string $hash
     * @return \StructType\AttachmentItemInfo
     */
    public function setHash($hash = null)
    {
        // validation for constraint: string
        if (!is_null($hash) && !is_string($hash)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hash)), __LINE__);
        }
        $this->hash = $hash;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AttachmentItemInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
