<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttachmentInfo StructType
 * @subpackage Structs
 */
class AttachmentInfo extends AbstractStructBase
{
    /**
     * The attachment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AttachmentItemInfo[]
     */
    public $attachment;
    /**
     * Constructor method for AttachmentInfo
     * @uses AttachmentInfo::setAttachment()
     * @param \StructType\AttachmentItemInfo[] $attachment
     */
    public function __construct(array $attachment = array())
    {
        $this
            ->setAttachment($attachment);
    }
    /**
     * Get attachment value
     * @return \StructType\AttachmentItemInfo[]|null
     */
    public function getAttachment()
    {
        return $this->attachment;
    }
    /**
     * Set attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentItemInfo[] $attachment
     * @return \StructType\AttachmentInfo
     */
    public function setAttachment(array $attachment = array())
    {
        foreach ($attachment as $attachmentInfoAttachmentItem) {
            // validation for constraint: itemType
            if (!$attachmentInfoAttachmentItem instanceof \StructType\AttachmentItemInfo) {
                throw new \InvalidArgumentException(sprintf('The attachment property can only contain items of \StructType\AttachmentItemInfo, "%s" given', is_object($attachmentInfoAttachmentItem) ? get_class($attachmentInfoAttachmentItem) : gettype($attachmentInfoAttachmentItem)), __LINE__);
            }
        }
        $this->attachment = $attachment;
        return $this;
    }
    /**
     * Add item to attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentItemInfo $item
     * @return \StructType\AttachmentInfo
     */
    public function addToAttachment(\StructType\AttachmentItemInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AttachmentItemInfo) {
            throw new \InvalidArgumentException(sprintf('The attachment property can only contain items of \StructType\AttachmentItemInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attachment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AttachmentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
