<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Appointment StructType
 * @subpackage Structs
 */
class Appointment extends CalendarItem
{
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:startDate
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:endDate
     * @var string
     */
    public $endDate;
    /**
     * The startDay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDay;
    /**
     * The endDay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDay;
    /**
     * The acceptLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:acceptLevel
     * @var string
     */
    public $acceptLevel;
    /**
     * The alarm
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Alarm
     */
    public $alarm;
    /**
     * The allDayEvent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $allDayEvent;
    /**
     * The place
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:place
     * @var string
     */
    public $place;
    /**
     * The timezone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Timezone
     */
    public $timezone;
    /**
     * Constructor method for Appointment
     * @uses Appointment::setStartDate()
     * @uses Appointment::setEndDate()
     * @uses Appointment::setStartDay()
     * @uses Appointment::setEndDay()
     * @uses Appointment::setAcceptLevel()
     * @uses Appointment::setAlarm()
     * @uses Appointment::setAllDayEvent()
     * @uses Appointment::setPlace()
     * @uses Appointment::setTimezone()
     * @param string $startDate
     * @param string $endDate
     * @param string $startDay
     * @param string $endDay
     * @param string $acceptLevel
     * @param \StructType\Alarm $alarm
     * @param bool $allDayEvent
     * @param string $place
     * @param \StructType\Timezone $timezone
     */
    public function __construct($startDate = null, $endDate = null, $startDay = null, $endDay = null, $acceptLevel = null, \StructType\Alarm $alarm = null, $allDayEvent = null, $place = null, \StructType\Timezone $timezone = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setStartDay($startDay)
            ->setEndDay($endDay)
            ->setAcceptLevel($acceptLevel)
            ->setAlarm($alarm)
            ->setAllDayEvent($allDayEvent)
            ->setPlace($place)
            ->setTimezone($timezone);
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\Appointment
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\Appointment
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get startDay value
     * @return string|null
     */
    public function getStartDay()
    {
        return $this->startDay;
    }
    /**
     * Set startDay value
     * @param string $startDay
     * @return \StructType\Appointment
     */
    public function setStartDay($startDay = null)
    {
        // validation for constraint: string
        if (!is_null($startDay) && !is_string($startDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDay)), __LINE__);
        }
        $this->startDay = $startDay;
        return $this;
    }
    /**
     * Get endDay value
     * @return string|null
     */
    public function getEndDay()
    {
        return $this->endDay;
    }
    /**
     * Set endDay value
     * @param string $endDay
     * @return \StructType\Appointment
     */
    public function setEndDay($endDay = null)
    {
        // validation for constraint: string
        if (!is_null($endDay) && !is_string($endDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDay)), __LINE__);
        }
        $this->endDay = $endDay;
        return $this;
    }
    /**
     * Get acceptLevel value
     * @return string|null
     */
    public function getAcceptLevel()
    {
        return $this->acceptLevel;
    }
    /**
     * Set acceptLevel value
     * @uses \EnumType\AcceptLevel::valueIsValid()
     * @uses \EnumType\AcceptLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $acceptLevel
     * @return \StructType\Appointment
     */
    public function setAcceptLevel($acceptLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AcceptLevel::valueIsValid($acceptLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $acceptLevel, implode(', ', \EnumType\AcceptLevel::getValidValues())), __LINE__);
        }
        $this->acceptLevel = $acceptLevel;
        return $this;
    }
    /**
     * Get alarm value
     * @return \StructType\Alarm|null
     */
    public function getAlarm()
    {
        return $this->alarm;
    }
    /**
     * Set alarm value
     * @param \StructType\Alarm $alarm
     * @return \StructType\Appointment
     */
    public function setAlarm(\StructType\Alarm $alarm = null)
    {
        $this->alarm = $alarm;
        return $this;
    }
    /**
     * Get allDayEvent value
     * @return bool|null
     */
    public function getAllDayEvent()
    {
        return $this->allDayEvent;
    }
    /**
     * Set allDayEvent value
     * @param bool $allDayEvent
     * @return \StructType\Appointment
     */
    public function setAllDayEvent($allDayEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($allDayEvent) && !is_bool($allDayEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allDayEvent)), __LINE__);
        }
        $this->allDayEvent = $allDayEvent;
        return $this;
    }
    /**
     * Get place value
     * @return string|null
     */
    public function getPlace()
    {
        return $this->place;
    }
    /**
     * Set place value
     * @param string $place
     * @return \StructType\Appointment
     */
    public function setPlace($place = null)
    {
        // validation for constraint: string
        if (!is_null($place) && !is_string($place)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($place)), __LINE__);
        }
        $this->place = $place;
        return $this;
    }
    /**
     * Get timezone value
     * @return \StructType\Timezone|null
     */
    public function getTimezone()
    {
        return $this->timezone;
    }
    /**
     * Set timezone value
     * @param \StructType\Timezone $timezone
     * @return \StructType\Appointment
     */
    public function setTimezone(\StructType\Timezone $timezone = null)
    {
        $this->timezone = $timezone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Appointment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
