<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressBookItem StructType
 * Meta informations extracted from the WSDL
 * - maxOccurs: unbounded
 * - minOccurs: 0
 * - type: xs:string
 * @subpackage Structs
 */
class AddressBookItem extends ContainerItem
{
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:uuid
     * - documentation: The UUID is the unique user ID on a given email system. This is used in various places to indicate that a sender or recipient is an user internal to the collaboration system instead of an external user (i.e. internet address).
     * @var string
     */
    public $uuid;
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The sync
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sync;
    /**
     * The domain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $domain;
    /**
     * The postOffice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postOffice;
    /**
     * The distinguishedName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $distinguishedName;
    /**
     * The userid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userid;
    /**
     * The PABGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PABGuid;
    /**
     * The visibility
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $visibility;
    /**
     * The external
     * @var bool
     */
    public $external;
    /**
     * Constructor method for AddressBookItem
     * @uses AddressBookItem::setUuid()
     * @uses AddressBookItem::setComment()
     * @uses AddressBookItem::setSync()
     * @uses AddressBookItem::setDomain()
     * @uses AddressBookItem::setPostOffice()
     * @uses AddressBookItem::setDistinguishedName()
     * @uses AddressBookItem::setUserid()
     * @uses AddressBookItem::setPABGuid()
     * @uses AddressBookItem::setVisibility()
     * @uses AddressBookItem::setExternal()
     * @param string $uuid
     * @param string $comment
     * @param string $sync
     * @param string $domain
     * @param string $postOffice
     * @param string $distinguishedName
     * @param string $userid
     * @param string $pABGuid
     * @param string $visibility
     * @param bool $external
     */
    public function __construct($uuid = null, $comment = null, $sync = null, $domain = null, $postOffice = null, $distinguishedName = null, $userid = null, $pABGuid = null, $visibility = null, $external = null)
    {
        $this
            ->setUuid($uuid)
            ->setComment($comment)
            ->setSync($sync)
            ->setDomain($domain)
            ->setPostOffice($postOffice)
            ->setDistinguishedName($distinguishedName)
            ->setUserid($userid)
            ->setPABGuid($pABGuid)
            ->setVisibility($visibility)
            ->setExternal($external);
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\AddressBookItem
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\AddressBookItem
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get sync value
     * @return string|null
     */
    public function getSync()
    {
        return $this->sync;
    }
    /**
     * Set sync value
     * @uses \EnumType\DeltaSyncType::valueIsValid()
     * @uses \EnumType\DeltaSyncType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sync
     * @return \StructType\AddressBookItem
     */
    public function setSync($sync = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeltaSyncType::valueIsValid($sync)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sync, implode(', ', \EnumType\DeltaSyncType::getValidValues())), __LINE__);
        }
        $this->sync = $sync;
        return $this;
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \StructType\AddressBookItem
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get postOffice value
     * @return string|null
     */
    public function getPostOffice()
    {
        return $this->postOffice;
    }
    /**
     * Set postOffice value
     * @param string $postOffice
     * @return \StructType\AddressBookItem
     */
    public function setPostOffice($postOffice = null)
    {
        // validation for constraint: string
        if (!is_null($postOffice) && !is_string($postOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postOffice)), __LINE__);
        }
        $this->postOffice = $postOffice;
        return $this;
    }
    /**
     * Get distinguishedName value
     * @return string|null
     */
    public function getDistinguishedName()
    {
        return $this->distinguishedName;
    }
    /**
     * Set distinguishedName value
     * @param string $distinguishedName
     * @return \StructType\AddressBookItem
     */
    public function setDistinguishedName($distinguishedName = null)
    {
        // validation for constraint: string
        if (!is_null($distinguishedName) && !is_string($distinguishedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distinguishedName)), __LINE__);
        }
        $this->distinguishedName = $distinguishedName;
        return $this;
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \StructType\AddressBookItem
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get PABGuid value
     * @return string|null
     */
    public function getPABGuid()
    {
        return $this->PABGuid;
    }
    /**
     * Set PABGuid value
     * @param string $pABGuid
     * @return \StructType\AddressBookItem
     */
    public function setPABGuid($pABGuid = null)
    {
        // validation for constraint: string
        if (!is_null($pABGuid) && !is_string($pABGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pABGuid)), __LINE__);
        }
        $this->PABGuid = $pABGuid;
        return $this;
    }
    /**
     * Get visibility value
     * @return string|null
     */
    public function getVisibility()
    {
        return $this->visibility;
    }
    /**
     * Set visibility value
     * @uses \EnumType\Visibility::valueIsValid()
     * @uses \EnumType\Visibility::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $visibility
     * @return \StructType\AddressBookItem
     */
    public function setVisibility($visibility = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Visibility::valueIsValid($visibility)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $visibility, implode(', ', \EnumType\Visibility::getValidValues())), __LINE__);
        }
        $this->visibility = $visibility;
        return $this;
    }
    /**
     * Get external value
     * @return bool|null
     */
    public function getExternal()
    {
        return $this->external;
    }
    /**
     * Set external value
     * @param bool $external
     * @return \StructType\AddressBookItem
     */
    public function setExternal($external = null)
    {
        // validation for constraint: boolean
        if (!is_null($external) && !is_bool($external)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($external)), __LINE__);
        }
        $this->external = $external;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressBookItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
