<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressBook StructType
 * Meta informations extracted from the WSDL
 * - minOccurs: 0
 * - type: xs:string
 * @subpackage Structs
 */
class AddressBook extends Item
{
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:description
     * @var string
     */
    public $description;
    /**
     * The isPersonal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isPersonal;
    /**
     * The isFrequentContacts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isFrequentContacts;
    /**
     * The count
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $count;
    /**
     * Constructor method for AddressBook
     * @uses AddressBook::setDescription()
     * @uses AddressBook::setIsPersonal()
     * @uses AddressBook::setIsFrequentContacts()
     * @uses AddressBook::setCount()
     * @param string $description
     * @param bool $isPersonal
     * @param bool $isFrequentContacts
     * @param int $count
     */
    public function __construct($description = null, $isPersonal = null, $isFrequentContacts = null, $count = null)
    {
        $this
            ->setDescription($description)
            ->setIsPersonal($isPersonal)
            ->setIsFrequentContacts($isFrequentContacts)
            ->setCount($count);
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\AddressBook
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isPersonal value
     * @return bool|null
     */
    public function getIsPersonal()
    {
        return $this->isPersonal;
    }
    /**
     * Set isPersonal value
     * @param bool $isPersonal
     * @return \StructType\AddressBook
     */
    public function setIsPersonal($isPersonal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPersonal) && !is_bool($isPersonal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPersonal)), __LINE__);
        }
        $this->isPersonal = $isPersonal;
        return $this;
    }
    /**
     * Get isFrequentContacts value
     * @return bool|null
     */
    public function getIsFrequentContacts()
    {
        return $this->isFrequentContacts;
    }
    /**
     * Set isFrequentContacts value
     * @param bool $isFrequentContacts
     * @return \StructType\AddressBook
     */
    public function setIsFrequentContacts($isFrequentContacts = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFrequentContacts) && !is_bool($isFrequentContacts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isFrequentContacts)), __LINE__);
        }
        $this->isFrequentContacts = $isFrequentContacts;
        return $this;
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\AddressBook
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !is_numeric($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressBook
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
