<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Account StructType
 * @subpackage Structs
 */
class Account extends Item
{
    /**
     * The from
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\From
     */
    public $from;
    /**
     * The serverTimeout
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $serverTimeout;
    /**
     * The flags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountFlags
     */
    public $flags;
    /**
     * The replyTo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $replyTo;
    /**
     * The organization
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $organization;
    /**
     * Constructor method for Account
     * @uses Account::setFrom()
     * @uses Account::setServerTimeout()
     * @uses Account::setFlags()
     * @uses Account::setReplyTo()
     * @uses Account::setOrganization()
     * @param \StructType\From $from
     * @param int $serverTimeout
     * @param \StructType\AccountFlags $flags
     * @param string $replyTo
     * @param string $organization
     */
    public function __construct(\StructType\From $from = null, $serverTimeout = null, \StructType\AccountFlags $flags = null, $replyTo = null, $organization = null)
    {
        $this
            ->setFrom($from)
            ->setServerTimeout($serverTimeout)
            ->setFlags($flags)
            ->setReplyTo($replyTo)
            ->setOrganization($organization);
    }
    /**
     * Get from value
     * @return \StructType\From|null
     */
    public function getFrom()
    {
        return $this->from;
    }
    /**
     * Set from value
     * @param \StructType\From $from
     * @return \StructType\Account
     */
    public function setFrom(\StructType\From $from = null)
    {
        $this->from = $from;
        return $this;
    }
    /**
     * Get serverTimeout value
     * @return int|null
     */
    public function getServerTimeout()
    {
        return $this->serverTimeout;
    }
    /**
     * Set serverTimeout value
     * @param int $serverTimeout
     * @return \StructType\Account
     */
    public function setServerTimeout($serverTimeout = null)
    {
        // validation for constraint: int
        if (!is_null($serverTimeout) && !is_numeric($serverTimeout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serverTimeout)), __LINE__);
        }
        $this->serverTimeout = $serverTimeout;
        return $this;
    }
    /**
     * Get flags value
     * @return \StructType\AccountFlags|null
     */
    public function getFlags()
    {
        return $this->flags;
    }
    /**
     * Set flags value
     * @param \StructType\AccountFlags $flags
     * @return \StructType\Account
     */
    public function setFlags(\StructType\AccountFlags $flags = null)
    {
        $this->flags = $flags;
        return $this;
    }
    /**
     * Get replyTo value
     * @return string|null
     */
    public function getReplyTo()
    {
        return $this->replyTo;
    }
    /**
     * Set replyTo value
     * @param string $replyTo
     * @return \StructType\Account
     */
    public function setReplyTo($replyTo = null)
    {
        // validation for constraint: string
        if (!is_null($replyTo) && !is_string($replyTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($replyTo)), __LINE__);
        }
        $this->replyTo = $replyTo;
        return $this;
    }
    /**
     * Get organization value
     * @return string|null
     */
    public function getOrganization()
    {
        return $this->organization;
    }
    /**
     * Set organization value
     * @param string $organization
     * @return \StructType\Account
     */
    public function setOrganization($organization = null)
    {
        // validation for constraint: string
        if (!is_null($organization) && !is_string($organization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organization)), __LINE__);
        }
        $this->organization = $organization;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Account
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
