<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessRightList StructType
 * @subpackage Structs
 */
class AccessRightList extends AbstractStructBase
{
    /**
     * The entry
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AccessRightEntry[]
     */
    public $entry;
    /**
     * Constructor method for AccessRightList
     * @uses AccessRightList::setEntry()
     * @param \StructType\AccessRightEntry[] $entry
     */
    public function __construct(array $entry = array())
    {
        $this
            ->setEntry($entry);
    }
    /**
     * Get entry value
     * @return \StructType\AccessRightEntry[]|null
     */
    public function getEntry()
    {
        return $this->entry;
    }
    /**
     * Set entry value
     * @throws \InvalidArgumentException
     * @param \StructType\AccessRightEntry[] $entry
     * @return \StructType\AccessRightList
     */
    public function setEntry(array $entry = array())
    {
        foreach ($entry as $accessRightListEntryItem) {
            // validation for constraint: itemType
            if (!$accessRightListEntryItem instanceof \StructType\AccessRightEntry) {
                throw new \InvalidArgumentException(sprintf('The entry property can only contain items of \StructType\AccessRightEntry, "%s" given', is_object($accessRightListEntryItem) ? get_class($accessRightListEntryItem) : gettype($accessRightListEntryItem)), __LINE__);
            }
        }
        $this->entry = $entry;
        return $this;
    }
    /**
     * Add item to entry value
     * @throws \InvalidArgumentException
     * @param \StructType\AccessRightEntry $item
     * @return \StructType\AccessRightList
     */
    public function addToEntry(\StructType\AccessRightEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccessRightEntry) {
            throw new \InvalidArgumentException(sprintf('The entry property can only contain items of \StructType\AccessRightEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->entry[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccessRightList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
