<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Remove ServiceType
 * @subpackage Services
 */
class Remove extends AbstractSoapClientBase
{
    /**
     * Sets the Session SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $session
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSession($session, $nameSpace = 'http://schemas.novell.com/2005/01/GroupWise/types', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'session', $session, $mustUnderstand, $actor);
    }
    /**
     * Sets the GwTrace SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $gwTrace
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderGwTrace($gwTrace, $nameSpace = 'http://schemas.novell.com/2005/01/GroupWise/types', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'gwTrace', $gwTrace, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named removeCustomDefinitionRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveCustomDefinitionRequest $removeCustomDefinitionReq
     * @return \StructType\RemoveCustomDefinitionResponse|bool
     */
    public function removeCustomDefinitionRequest(\StructType\RemoveCustomDefinitionRequest $removeCustomDefinitionReq)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCustomDefinitionRequest($removeCustomDefinitionReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeItemRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveItemRequest $removeItemReq
     * @return \StructType\RemoveItemResponse|bool
     */
    public function removeItemRequest(\StructType\RemoveItemRequest $removeItemReq)
    {
        try {
            $this->setResult(self::getSoapClient()->removeItemRequest($removeItemReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeItemsRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveItemsRequest $removeItemsReq
     * @return \StructType\RemoveItemsResponse|bool
     */
    public function removeItemsRequest(\StructType\RemoveItemsRequest $removeItemsReq)
    {
        try {
            $this->setResult(self::getSoapClient()->removeItemsRequest($removeItemsReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeJunkEntryRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveJunkEntryRequest $removeJunkEntryReq
     * @return \StructType\RemoveJunkEntryResponse|bool
     */
    public function removeJunkEntryRequest(\StructType\RemoveJunkEntryRequest $removeJunkEntryReq)
    {
        try {
            $this->setResult(self::getSoapClient()->removeJunkEntryRequest($removeJunkEntryReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMembersRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveMembersRequest $removeMembersReq
     * @return \StructType\RemoveMembersResponse|bool
     */
    public function removeMembersRequest(\StructType\RemoveMembersRequest $removeMembersReq)
    {
        try {
            $this->setResult(self::getSoapClient()->removeMembersRequest($removeMembersReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeNotifyRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveNotifyRequest $removeNotifyReq
     * @return \StructType\RemoveNotifyResponse|bool
     */
    public function removeNotifyRequest(\StructType\RemoveNotifyRequest $removeNotifyReq)
    {
        try {
            $this->setResult(self::getSoapClient()->removeNotifyRequest($removeNotifyReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeProxyAccessRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveProxyAccessRequest $removeProxyAccessReq
     * @return \StructType\RemoveProxyAccessResponse|bool
     */
    public function removeProxyAccessRequest(\StructType\RemoveProxyAccessRequest $removeProxyAccessReq)
    {
        try {
            $this->setResult(self::getSoapClient()->removeProxyAccessRequest($removeProxyAccessReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeProxyUserRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveProxyUserRequest $removeProxyUserReq
     * @return \StructType\RemoveProxyUserResponse|bool
     */
    public function removeProxyUserRequest(\StructType\RemoveProxyUserRequest $removeProxyUserReq)
    {
        try {
            $this->setResult(self::getSoapClient()->removeProxyUserRequest($removeProxyUserReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSignatureRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveSignatureRequest $removeSignatureReq
     * @return \StructType\RemoveSignatureResponse|bool
     */
    public function removeSignatureRequest(\StructType\RemoveSignatureRequest $removeSignatureReq)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSignatureRequest($removeSignatureReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeEventConfigurationRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveEventConfigurationRequest $removeEventConfigurationReq
     * @return \StructType\RemoveEventConfigurationResponse|bool
     */
    public function removeEventConfigurationRequest(\StructType\RemoveEventConfigurationRequest $removeEventConfigurationReq)
    {
        try {
            $this->setResult(self::getSoapClient()->removeEventConfigurationRequest($removeEventConfigurationReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeEventsRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveEventsRequest $removeEventsReq
     * @return \StructType\RemoveEventsResponse|bool
     */
    public function removeEventsRequest(\StructType\RemoveEventsRequest $removeEventsReq)
    {
        try {
            $this->setResult(self::getSoapClient()->removeEventsRequest($removeEventsReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RemoveCustomDefinitionResponse|\StructType\RemoveEventConfigurationResponse|\StructType\RemoveEventsResponse|\StructType\RemoveItemResponse|\StructType\RemoveItemsResponse|\StructType\RemoveJunkEntryResponse|\StructType\RemoveMembersResponse|\StructType\RemoveNotifyResponse|\StructType\RemoveProxyAccessResponse|\StructType\RemoveProxyUserResponse|\StructType\RemoveSignatureResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
