<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Modify ServiceType
 * @subpackage Services
 */
class Modify extends AbstractSoapClientBase
{
    /**
     * Sets the Session SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $session
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSession($session, $nameSpace = 'http://schemas.novell.com/2005/01/GroupWise/types', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'session', $session, $mustUnderstand, $actor);
    }
    /**
     * Sets the GwTrace SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $gwTrace
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderGwTrace($gwTrace, $nameSpace = 'http://schemas.novell.com/2005/01/GroupWise/types', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'gwTrace', $gwTrace, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named modifyItemRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModifyItemRequest $modifyItemReq
     * @return \StructType\ModifyItemResponse|bool
     */
    public function modifyItemRequest(\StructType\ModifyItemRequest $modifyItemReq)
    {
        try {
            $this->setResult(self::getSoapClient()->modifyItemRequest($modifyItemReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named modifyItemsRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModifyItemsRequest $modifyItemsReq
     * @return \StructType\ModifyItemsResponse|bool
     */
    public function modifyItemsRequest(\StructType\ModifyItemsRequest $modifyItemsReq)
    {
        try {
            $this->setResult(self::getSoapClient()->modifyItemsRequest($modifyItemsReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named modifyJunkEntryRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModifyJunkEntryRequest $modifyJunkEntryReq
     * @return \StructType\ModifyJunkEntryResponse|bool
     */
    public function modifyJunkEntryRequest(\StructType\ModifyJunkEntryRequest $modifyJunkEntryReq)
    {
        try {
            $this->setResult(self::getSoapClient()->modifyJunkEntryRequest($modifyJunkEntryReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named modifyJunkMailSettingsRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModifyJunkMailSettingsRequest $modifyJunkMailSettingsReq
     * @return \StructType\ModifyJunkMailSettingsResponse|bool
     */
    public function modifyJunkMailSettingsRequest(\StructType\ModifyJunkMailSettingsRequest $modifyJunkMailSettingsReq)
    {
        try {
            $this->setResult(self::getSoapClient()->modifyJunkMailSettingsRequest($modifyJunkMailSettingsReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named modifyNotifyRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModifyNotifyRequest $modifyNotifyReq
     * @return \StructType\ModifyNotifyResponse|bool
     */
    public function modifyNotifyRequest(\StructType\ModifyNotifyRequest $modifyNotifyReq)
    {
        try {
            $this->setResult(self::getSoapClient()->modifyNotifyRequest($modifyNotifyReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named modifyPasswordRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModifyPasswordRequest $modifyPasswordReq
     * @return \StructType\ModifyPasswordResponse|bool
     */
    public function modifyPasswordRequest(\StructType\ModifyPasswordRequest $modifyPasswordReq)
    {
        try {
            $this->setResult(self::getSoapClient()->modifyPasswordRequest($modifyPasswordReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named modifyProxyAccessRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModifyProxyAccessRequest $modifyProxyAccessReq
     * @return \StructType\ModifyProxyAccessResponse|bool
     */
    public function modifyProxyAccessRequest(\StructType\ModifyProxyAccessRequest $modifyProxyAccessReq)
    {
        try {
            $this->setResult(self::getSoapClient()->modifyProxyAccessRequest($modifyProxyAccessReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named modifySettingsRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModifySettingsRequest $modifySettingsReq
     * @return \StructType\ModifySettingsResponse|bool
     */
    public function modifySettingsRequest(\StructType\ModifySettingsRequest $modifySettingsReq)
    {
        try {
            $this->setResult(self::getSoapClient()->modifySettingsRequest($modifySettingsReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named modifySignaturesRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModifySignaturesRequest $modifySignaturesReq
     * @return \StructType\ModifySignaturesResponse|bool
     */
    public function modifySignaturesRequest(\StructType\ModifySignaturesRequest $modifySignaturesReq)
    {
        try {
            $this->setResult(self::getSoapClient()->modifySignaturesRequest($modifySignaturesReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ModifyItemResponse|\StructType\ModifyItemsResponse|\StructType\ModifyJunkEntryResponse|\StructType\ModifyJunkMailSettingsResponse|\StructType\ModifyNotifyResponse|\StructType\ModifyPasswordResponse|\StructType\ModifyProxyAccessResponse|\StructType\ModifySettingsResponse|\StructType\ModifySignaturesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
