<?php

namespace EnumType;

/**
 * This class stands for VersionEventType EnumType
 * @subpackage Enumerations
 */
class VersionEventType
{
    /**
     * Constant for value 'archive'
     * @return string 'archive'
     */
    const VALUE_ARCHIVE = 'archive';
    /**
     * Constant for value 'checkIn'
     * @return string 'checkIn'
     */
    const VALUE_CHECK_IN = 'checkIn';
    /**
     * Constant for value 'checkOut'
     * @return string 'checkOut'
     */
    const VALUE_CHECK_OUT = 'checkOut';
    /**
     * Constant for value 'copyIn'
     * @return string 'copyIn'
     */
    const VALUE_COPY_IN = 'copyIn';
    /**
     * Constant for value 'copyOut'
     * @return string 'copyOut'
     */
    const VALUE_COPY_OUT = 'copyOut';
    /**
     * Constant for value 'copyVersion'
     * @return string 'copyVersion'
     */
    const VALUE_COPY_VERSION = 'copyVersion';
    /**
     * Constant for value 'created'
     * @return string 'created'
     */
    const VALUE_CREATED = 'created';
    /**
     * Constant for value 'deleteVersion'
     * @return string 'deleteVersion'
     */
    const VALUE_DELETE_VERSION = 'deleteVersion';
    /**
     * Constant for value 'endAccess'
     * @return string 'endAccess'
     */
    const VALUE_END_ACCESS = 'endAccess';
    /**
     * Constant for value 'resetStatus'
     * @return string 'resetStatus'
     */
    const VALUE_RESET_STATUS = 'resetStatus';
    /**
     * Constant for value 'restore'
     * @return string 'restore'
     */
    const VALUE_RESTORE = 'restore';
    /**
     * Constant for value 'retrieve'
     * @return string 'retrieve'
     */
    const VALUE_RETRIEVE = 'retrieve';
    /**
     * Constant for value 'securityModified'
     * @return string 'securityModified'
     */
    const VALUE_SECURITY_MODIFIED = 'securityModified';
    /**
     * Constant for value 'versionDownloaded'
     * @return string 'versionDownloaded'
     */
    const VALUE_VERSION_DOWNLOADED = 'versionDownloaded';
    /**
     * Constant for value 'viewed'
     * @return string 'viewed'
     */
    const VALUE_VIEWED = 'viewed';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ARCHIVE
     * @uses self::VALUE_CHECK_IN
     * @uses self::VALUE_CHECK_OUT
     * @uses self::VALUE_COPY_IN
     * @uses self::VALUE_COPY_OUT
     * @uses self::VALUE_COPY_VERSION
     * @uses self::VALUE_CREATED
     * @uses self::VALUE_DELETE_VERSION
     * @uses self::VALUE_END_ACCESS
     * @uses self::VALUE_RESET_STATUS
     * @uses self::VALUE_RESTORE
     * @uses self::VALUE_RETRIEVE
     * @uses self::VALUE_SECURITY_MODIFIED
     * @uses self::VALUE_VERSION_DOWNLOADED
     * @uses self::VALUE_VIEWED
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ARCHIVE,
            self::VALUE_CHECK_IN,
            self::VALUE_CHECK_OUT,
            self::VALUE_COPY_IN,
            self::VALUE_COPY_OUT,
            self::VALUE_COPY_VERSION,
            self::VALUE_CREATED,
            self::VALUE_DELETE_VERSION,
            self::VALUE_END_ACCESS,
            self::VALUE_RESET_STATUS,
            self::VALUE_RESTORE,
            self::VALUE_RETRIEVE,
            self::VALUE_SECURITY_MODIFIED,
            self::VALUE_VERSION_DOWNLOADED,
            self::VALUE_VIEWED,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
