<?php

namespace EnumType;

/**
 * This class stands for SourceType EnumType
 * @subpackage Enumerations
 */
class SourceType
{
    /**
     * Constant for value 'Library'
     * @return string 'Library'
     */
    const VALUE_LIBRARY = 'Library';
    /**
     * Constant for value 'User'
     * @return string 'User'
     */
    const VALUE_USER = 'User';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LIBRARY
     * @uses self::VALUE_USER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LIBRARY,
            self::VALUE_USER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
