<?php

namespace EnumType;

/**
 * This class stands for RuleActionType EnumType
 * @subpackage Enumerations
 */
class RuleActionType
{
    /**
     * Constant for value 'Accept'
     * @return string 'Accept'
     */
    const VALUE_ACCEPT = 'Accept';
    /**
     * Constant for value 'Archive'
     * @return string 'Archive'
     */
    const VALUE_ARCHIVE = 'Archive';
    /**
     * Constant for value 'Category'
     * @return string 'Category'
     */
    const VALUE_CATEGORY = 'Category';
    /**
     * Constant for value 'Delegate'
     * @return string 'Delegate'
     */
    const VALUE_DELEGATE = 'Delegate';
    /**
     * Constant for value 'Delete'
     * @return string 'Delete'
     */
    const VALUE_DELETE = 'Delete';
    /**
     * Constant for value 'Forward'
     * @return string 'Forward'
     */
    const VALUE_FORWARD = 'Forward';
    /**
     * Constant for value 'Link'
     * @return string 'Link'
     */
    const VALUE_LINK = 'Link';
    /**
     * Constant for value 'MarkPrivate'
     * @return string 'MarkPrivate'
     */
    const VALUE_MARK_PRIVATE = 'MarkPrivate';
    /**
     * Constant for value 'MarkRead'
     * @return string 'MarkRead'
     */
    const VALUE_MARK_READ = 'MarkRead';
    /**
     * Constant for value 'MarkUnread'
     * @return string 'MarkUnread'
     */
    const VALUE_MARK_UNREAD = 'MarkUnread';
    /**
     * Constant for value 'Move'
     * @return string 'Move'
     */
    const VALUE_MOVE = 'Move';
    /**
     * Constant for value 'Purge'
     * @return string 'Purge'
     */
    const VALUE_PURGE = 'Purge';
    /**
     * Constant for value 'Reply'
     * @return string 'Reply'
     */
    const VALUE_REPLY = 'Reply';
    /**
     * Constant for value 'ReplyWithText'
     * @return string 'ReplyWithText'
     */
    const VALUE_REPLY_WITH_TEXT = 'ReplyWithText';
    /**
     * Constant for value 'Send'
     * @return string 'Send'
     */
    const VALUE_SEND = 'Send';
    /**
     * Constant for value 'StopRules'
     * @return string 'StopRules'
     */
    const VALUE_STOP_RULES = 'StopRules';
    /**
     * Constant for value 'FlatForward'
     * @return string 'FlatForward'
     */
    const VALUE_FLAT_FORWARD = 'FlatForward';
    /**
     * Constant for value 'SimpleForward'
     * @return string 'SimpleForward'
     */
    const VALUE_SIMPLE_FORWARD = 'SimpleForward';
    /**
     * Constant for value 'Protect'
     * @return string 'Protect'
     */
    const VALUE_PROTECT = 'Protect';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCEPT
     * @uses self::VALUE_ARCHIVE
     * @uses self::VALUE_CATEGORY
     * @uses self::VALUE_DELEGATE
     * @uses self::VALUE_DELETE
     * @uses self::VALUE_FORWARD
     * @uses self::VALUE_LINK
     * @uses self::VALUE_MARK_PRIVATE
     * @uses self::VALUE_MARK_READ
     * @uses self::VALUE_MARK_UNREAD
     * @uses self::VALUE_MOVE
     * @uses self::VALUE_PURGE
     * @uses self::VALUE_REPLY
     * @uses self::VALUE_REPLY_WITH_TEXT
     * @uses self::VALUE_SEND
     * @uses self::VALUE_STOP_RULES
     * @uses self::VALUE_FLAT_FORWARD
     * @uses self::VALUE_SIMPLE_FORWARD
     * @uses self::VALUE_PROTECT
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCEPT,
            self::VALUE_ARCHIVE,
            self::VALUE_CATEGORY,
            self::VALUE_DELEGATE,
            self::VALUE_DELETE,
            self::VALUE_FORWARD,
            self::VALUE_LINK,
            self::VALUE_MARK_PRIVATE,
            self::VALUE_MARK_READ,
            self::VALUE_MARK_UNREAD,
            self::VALUE_MOVE,
            self::VALUE_PURGE,
            self::VALUE_REPLY,
            self::VALUE_REPLY_WITH_TEXT,
            self::VALUE_SEND,
            self::VALUE_STOP_RULES,
            self::VALUE_FLAT_FORWARD,
            self::VALUE_SIMPLE_FORWARD,
            self::VALUE_PROTECT,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
