<?php

namespace EnumType;

/**
 * This class stands for RetractType EnumType
 * @subpackage Enumerations
 */
class RetractType
{
    /**
     * Constant for value 'myMailbox'
     * @return string 'myMailbox'
     */
    const VALUE_MY_MAILBOX = 'myMailbox';
    /**
     * Constant for value 'recipientMailboxes'
     * @return string 'recipientMailboxes'
     */
    const VALUE_RECIPIENT_MAILBOXES = 'recipientMailboxes';
    /**
     * Constant for value 'allMailboxes'
     * @return string 'allMailboxes'
     */
    const VALUE_ALL_MAILBOXES = 'allMailboxes';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MY_MAILBOX
     * @uses self::VALUE_RECIPIENT_MAILBOXES
     * @uses self::VALUE_ALL_MAILBOXES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MY_MAILBOX,
            self::VALUE_RECIPIENT_MAILBOXES,
            self::VALUE_ALL_MAILBOXES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
