<?php

namespace EnumType;

/**
 * This class stands for RecipientType EnumType
 * @subpackage Enumerations
 */
class RecipientType
{
    /**
     * Constant for value 'User'
     * @return string 'User'
     */
    const VALUE_USER = 'User';
    /**
     * Constant for value 'Resource'
     * @return string 'Resource'
     */
    const VALUE_RESOURCE = 'Resource';
    /**
     * Constant for value 'PersonalGroup'
     * @return string 'PersonalGroup'
     */
    const VALUE_PERSONAL_GROUP = 'PersonalGroup';
    /**
     * Constant for value 'SystemGroup'
     * @return string 'SystemGroup'
     */
    const VALUE_SYSTEM_GROUP = 'SystemGroup';
    /**
     * Constant for value 'PersonalGroupMember'
     * @return string 'PersonalGroupMember'
     */
    const VALUE_PERSONAL_GROUP_MEMBER = 'PersonalGroupMember';
    /**
     * Constant for value 'SystemGroupMember'
     * @return string 'SystemGroupMember'
     */
    const VALUE_SYSTEM_GROUP_MEMBER = 'SystemGroupMember';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_USER
     * @uses self::VALUE_RESOURCE
     * @uses self::VALUE_PERSONAL_GROUP
     * @uses self::VALUE_SYSTEM_GROUP
     * @uses self::VALUE_PERSONAL_GROUP_MEMBER
     * @uses self::VALUE_SYSTEM_GROUP_MEMBER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_USER,
            self::VALUE_RESOURCE,
            self::VALUE_PERSONAL_GROUP,
            self::VALUE_SYSTEM_GROUP,
            self::VALUE_PERSONAL_GROUP_MEMBER,
            self::VALUE_SYSTEM_GROUP_MEMBER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
