<?php

namespace EnumType;

/**
 * This class stands for Method EnumType
 * @subpackage Enumerations
 */
class Method
{
    /**
     * Constant for value 'update'
     * @return string 'update'
     */
    const VALUE_UPDATE = 'update';
    /**
     * Constant for value 'add'
     * @return string 'add'
     */
    const VALUE_ADD = 'add';
    /**
     * Constant for value 'delete'
     * @return string 'delete'
     */
    const VALUE_DELETE = 'delete';
    /**
     * Constant for value 'deleteAll'
     * @return string 'deleteAll'
     */
    const VALUE_DELETE_ALL = 'deleteAll';
    /**
     * Constant for value 'bitSet'
     * @return string 'bitSet'
     */
    const VALUE_BIT_SET = 'bitSet';
    /**
     * Constant for value 'bitClear'
     * @return string 'bitClear'
     */
    const VALUE_BIT_CLEAR = 'bitClear';
    /**
     * Constant for value 'ignore'
     * @return string 'ignore'
     */
    const VALUE_IGNORE = 'ignore';
    /**
     * Constant for value 'valid'
     * @return string 'valid'
     */
    const VALUE_VALID = 'valid';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UPDATE
     * @uses self::VALUE_ADD
     * @uses self::VALUE_DELETE
     * @uses self::VALUE_DELETE_ALL
     * @uses self::VALUE_BIT_SET
     * @uses self::VALUE_BIT_CLEAR
     * @uses self::VALUE_IGNORE
     * @uses self::VALUE_VALID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UPDATE,
            self::VALUE_ADD,
            self::VALUE_DELETE,
            self::VALUE_DELETE_ALL,
            self::VALUE_BIT_SET,
            self::VALUE_BIT_CLEAR,
            self::VALUE_IGNORE,
            self::VALUE_VALID,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
