<?php

namespace EnumType;

/**
 * This class stands for JunkHandlingListType EnumType
 * @subpackage Enumerations
 */
class JunkHandlingListType
{
    /**
     * Constant for value 'junk'
     * @return string 'junk'
     */
    const VALUE_JUNK = 'junk';
    /**
     * Constant for value 'block'
     * @return string 'block'
     */
    const VALUE_BLOCK = 'block';
    /**
     * Constant for value 'trust'
     * @return string 'trust'
     */
    const VALUE_TRUST = 'trust';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_JUNK
     * @uses self::VALUE_BLOCK
     * @uses self::VALUE_TRUST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_JUNK,
            self::VALUE_BLOCK,
            self::VALUE_TRUST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
