<?php

namespace EnumType;

/**
 * This class stands for ItemOptionsPriority EnumType
 * @subpackage Enumerations
 */
class ItemOptionsPriority
{
    /**
     * Constant for value 'High'
     * @return string 'High'
     */
    const VALUE_HIGH = 'High';
    /**
     * Constant for value 'Standard'
     * @return string 'Standard'
     */
    const VALUE_STANDARD = 'Standard';
    /**
     * Constant for value 'Low'
     * @return string 'Low'
     */
    const VALUE_LOW = 'Low';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HIGH
     * @uses self::VALUE_STANDARD
     * @uses self::VALUE_LOW
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HIGH,
            self::VALUE_STANDARD,
            self::VALUE_LOW,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
