<?php

namespace EnumType;

/**
 * This class stands for HTMLImages EnumType
 * @subpackage Enumerations
 */
class HTMLImages
{
    /**
     * Constant for value 'always'
     * @return string 'always'
     */
    const VALUE_ALWAYS = 'always';
    /**
     * Constant for value 'never'
     * @return string 'never'
     */
    const VALUE_NEVER = 'never';
    /**
     * Constant for value 'checkFrequentContacts'
     * @return string 'checkFrequentContacts'
     */
    const VALUE_CHECK_FREQUENT_CONTACTS = 'checkFrequentContacts';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALWAYS
     * @uses self::VALUE_NEVER
     * @uses self::VALUE_CHECK_FREQUENT_CONTACTS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALWAYS,
            self::VALUE_NEVER,
            self::VALUE_CHECK_FREQUENT_CONTACTS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
