<?php

namespace EnumType;

/**
 * This class stands for FolderType EnumType
 * @subpackage Enumerations
 */
class FolderType
{
    /**
     * Constant for value 'Mailbox'
     * @return string 'Mailbox'
     */
    const VALUE_MAILBOX = 'Mailbox';
    /**
     * Constant for value 'SentItems'
     * @return string 'SentItems'
     */
    const VALUE_SENT_ITEMS = 'SentItems';
    /**
     * Constant for value 'Draft'
     * @return string 'Draft'
     */
    const VALUE_DRAFT = 'Draft';
    /**
     * Constant for value 'Trash'
     * @return string 'Trash'
     */
    const VALUE_TRASH = 'Trash';
    /**
     * Constant for value 'Calendar'
     * @return string 'Calendar'
     */
    const VALUE_CALENDAR = 'Calendar';
    /**
     * Constant for value 'Contacts'
     * @return string 'Contacts'
     */
    const VALUE_CONTACTS = 'Contacts';
    /**
     * Constant for value 'Documents'
     * @return string 'Documents'
     */
    const VALUE_DOCUMENTS = 'Documents';
    /**
     * Constant for value 'Checklist'
     * @return string 'Checklist'
     */
    const VALUE_CHECKLIST = 'Checklist';
    /**
     * Constant for value 'Cabinet'
     * @return string 'Cabinet'
     */
    const VALUE_CABINET = 'Cabinet';
    /**
     * Constant for value 'MAPIRoot'
     * @return string 'MAPIRoot'
     */
    const VALUE_MAPIROOT = 'MAPIRoot';
    /**
     * Constant for value 'Normal'
     * @return string 'Normal'
     */
    const VALUE_NORMAL = 'Normal';
    /**
     * Constant for value 'NNTPServer'
     * @return string 'NNTPServer'
     */
    const VALUE_NNTPSERVER = 'NNTPServer';
    /**
     * Constant for value 'NNTPNewsGroup'
     * @return string 'NNTPNewsGroup'
     */
    const VALUE_NNTPNEWS_GROUP = 'NNTPNewsGroup';
    /**
     * Constant for value 'IMAP'
     * @return string 'IMAP'
     */
    const VALUE_IMAP = 'IMAP';
    /**
     * Constant for value 'Query'
     * @return string 'Query'
     */
    const VALUE_QUERY = 'Query';
    /**
     * Constant for value 'Root'
     * @return string 'Root'
     */
    const VALUE_ROOT = 'Root';
    /**
     * Constant for value 'JunkMail'
     * @return string 'JunkMail'
     */
    const VALUE_JUNK_MAIL = 'JunkMail';
    /**
     * Constant for value 'Notes'
     * @return string 'Notes'
     */
    const VALUE_NOTES = 'Notes';
    /**
     * Constant for value 'RSS'
     * @return string 'RSS'
     */
    const VALUE_RSS = 'RSS';
    /**
     * Constant for value 'Subscribe'
     * @return string 'Subscribe'
     */
    const VALUE_SUBSCRIBE = 'Subscribe';
    /**
     * Constant for value 'UserContacts'
     * @return string 'UserContacts'
     */
    const VALUE_USER_CONTACTS = 'UserContacts';
    /**
     * Constant for value 'Proxy'
     * @return string 'Proxy'
     */
    const VALUE_PROXY = 'Proxy';
    /**
     * Constant for value 'Teaming'
     * @return string 'Teaming'
     */
    const VALUE_TEAMING = 'Teaming';
    /**
     * Constant for value 'TeamingMyTeams'
     * @return string 'TeamingMyTeams'
     */
    const VALUE_TEAMING_MY_TEAMS = 'TeamingMyTeams';
    /**
     * Constant for value 'TeamingFavorites'
     * @return string 'TeamingFavorites'
     */
    const VALUE_TEAMING_FAVORITES = 'TeamingFavorites';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MAILBOX
     * @uses self::VALUE_SENT_ITEMS
     * @uses self::VALUE_DRAFT
     * @uses self::VALUE_TRASH
     * @uses self::VALUE_CALENDAR
     * @uses self::VALUE_CONTACTS
     * @uses self::VALUE_DOCUMENTS
     * @uses self::VALUE_CHECKLIST
     * @uses self::VALUE_CABINET
     * @uses self::VALUE_MAPIROOT
     * @uses self::VALUE_NORMAL
     * @uses self::VALUE_NNTPSERVER
     * @uses self::VALUE_NNTPNEWS_GROUP
     * @uses self::VALUE_IMAP
     * @uses self::VALUE_QUERY
     * @uses self::VALUE_ROOT
     * @uses self::VALUE_JUNK_MAIL
     * @uses self::VALUE_NOTES
     * @uses self::VALUE_RSS
     * @uses self::VALUE_SUBSCRIBE
     * @uses self::VALUE_USER_CONTACTS
     * @uses self::VALUE_PROXY
     * @uses self::VALUE_TEAMING
     * @uses self::VALUE_TEAMING_MY_TEAMS
     * @uses self::VALUE_TEAMING_FAVORITES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MAILBOX,
            self::VALUE_SENT_ITEMS,
            self::VALUE_DRAFT,
            self::VALUE_TRASH,
            self::VALUE_CALENDAR,
            self::VALUE_CONTACTS,
            self::VALUE_DOCUMENTS,
            self::VALUE_CHECKLIST,
            self::VALUE_CABINET,
            self::VALUE_MAPIROOT,
            self::VALUE_NORMAL,
            self::VALUE_NNTPSERVER,
            self::VALUE_NNTPNEWS_GROUP,
            self::VALUE_IMAP,
            self::VALUE_QUERY,
            self::VALUE_ROOT,
            self::VALUE_JUNK_MAIL,
            self::VALUE_NOTES,
            self::VALUE_RSS,
            self::VALUE_SUBSCRIBE,
            self::VALUE_USER_CONTACTS,
            self::VALUE_PROXY,
            self::VALUE_TEAMING,
            self::VALUE_TEAMING_MY_TEAMS,
            self::VALUE_TEAMING_FAVORITES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
