<?php

namespace EnumType;

/**
 * This class stands for FolderACLStatus EnumType
 * @subpackage Enumerations
 */
class FolderACLStatus
{
    /**
     * Constant for value 'pending'
     * @return string 'pending'
     */
    const VALUE_PENDING = 'pending';
    /**
     * Constant for value 'accepted'
     * @return string 'accepted'
     */
    const VALUE_ACCEPTED = 'accepted';
    /**
     * Constant for value 'deleted'
     * @return string 'deleted'
     */
    const VALUE_DELETED = 'deleted';
    /**
     * Constant for value 'opened'
     * @return string 'opened'
     */
    const VALUE_OPENED = 'opened';
    /**
     * Constant for value 'owner'
     * @return string 'owner'
     */
    const VALUE_OWNER = 'owner';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_ACCEPTED
     * @uses self::VALUE_DELETED
     * @uses self::VALUE_OPENED
     * @uses self::VALUE_OWNER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PENDING,
            self::VALUE_ACCEPTED,
            self::VALUE_DELETED,
            self::VALUE_OPENED,
            self::VALUE_OWNER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
